/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.faces.view.facelets.FaceletContext;

public class IterationIdManager {
    private static final String _STACK_OF_TRACKED_IDS = "com.sun.faces.facelets.tag.js._TRACKED_IDS";

    public static boolean registerLiteralId(FaceletContext ctx, String id) {
        Set<String> trackedIds = IterationIdManager._getStackOfTrackedIds(ctx).peek();
        if (trackedIds == null) {
            return false;
        }
        if (trackedIds.contains(id)) {
            return true;
        }
        trackedIds.add(id);
        return false;
    }

    public static void startIteration(FaceletContext ctx) {
        Deque<Set<String>> stack = IterationIdManager._getStackOfTrackedIds(ctx);
        Set<String> current = stack.peek();
        if (current == null) {
            current = new HashSet<String>();
        }
        stack.push(current);
    }

    public static void stopIteration(FaceletContext ctx) {
        IterationIdManager._getStackOfTrackedIds(ctx).pop();
    }

    public static void startNamingContainer(FaceletContext ctx) {
        IterationIdManager._getStackOfTrackedIds(ctx).push(null);
    }

    public static void stopNamingContainer(FaceletContext ctx) {
        IterationIdManager._getStackOfTrackedIds(ctx).pop();
    }

    static boolean isIterating(FaceletContext context) {
        Deque iterationIds = (Deque)context.getAttribute(_STACK_OF_TRACKED_IDS);
        return iterationIds != null && iterationIds.peek() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Deque<Set<String>> _getStackOfTrackedIds(FaceletContext ctx) {
        LinkedList stack = (LinkedList)ctx.getAttribute(_STACK_OF_TRACKED_IDS);
        if (stack != null) return stack;
        Class<IterationIdManager> clazz = IterationIdManager.class;
        synchronized (IterationIdManager.class) {
            stack = (Deque)ctx.getAttribute(_STACK_OF_TRACKED_IDS);
            if (stack != null) return stack;
            stack = new LinkedList();
            ctx.setAttribute(_STACK_OF_TRACKED_IDS, stack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stack;
        }
    }
}

