/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.events.threaded;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.messaging.Topic;
import org.glassfish.hk2.api.messaging.TopicDistributionService;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@Named
@Rank(value=100)
public class ThreadedEventDistributor
implements TopicDistributionService {
    @Inject
    @Named(value="HK2TopicDistributionService")
    private TopicDistributionService defaultDistributor;

    public void distributeMessage(Topic<?> topic, Object message) {
        Thread t = new Thread((Runnable)new Distributor(topic, message), "TopicDistributor");
        t.setDaemon(true);
        t.start();
    }

    private final class Distributor
    implements Runnable {
        private final Topic<?> topic;
        private final Object message;

        private Distributor(Topic<?> topic, Object message) {
            this.topic = topic;
            this.message = message;
        }

        @Override
        public void run() {
            ThreadedEventDistributor.this.defaultDistributor.distributeMessage(this.topic, this.message);
        }
    }
}

