/*
 * Decompiled with CFR 0.152.
 */
package org.acme.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ValidationInformation;
import org.glassfish.hk2.api.Validator;

public class ValidatorImpl
implements Validator {
    private static final boolean VERBOSE = Boolean.parseBoolean(System.getProperty("org.jvnet.hk2.examples.securitylockdown.debug", "false"));
    private static final String ACCESS_IN_PACKAGE = "accessClassInPackage.";

    private boolean validateBindAndUnbind() {
        return ValidatorImpl.checkPerm(new AllPermission());
    }

    private boolean validateLookupAPI(ActiveDescriptor<?> candidate) {
        List<Permission> lookupPermissions = ValidatorImpl.getLookupPermissions(candidate);
        for (Permission lookupPermission : lookupPermissions) {
            if (ValidatorImpl.checkPerm(lookupPermission)) continue;
            if (VERBOSE) {
                System.out.println("candidate " + candidate + " LOOKUP FAILED the security check for permission " + lookupPermission);
            }
            return false;
        }
        return true;
    }

    private boolean validateInjection(ActiveDescriptor<?> candidate, Injectee injectee) {
        List<Permission> lookupPermissions = ValidatorImpl.getLookupPermissions(candidate);
        final Class injecteeClass = injectee.getInjecteeClass();
        ProtectionDomain pd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return injecteeClass.getProtectionDomain();
            }
        });
        for (Permission lookupPermission : lookupPermissions) {
            if (pd.implies(lookupPermission)) continue;
            if (VERBOSE) {
                System.out.println("candidate " + candidate + " injectee " + injectee + " LOOKUP FAILED the security check for " + lookupPermission);
            }
            return false;
        }
        return true;
    }

    private boolean validateLookup(ActiveDescriptor<?> candidate, Injectee injectee) {
        if (injectee == null) {
            return this.validateLookupAPI(candidate);
        }
        return this.validateInjection(candidate, injectee);
    }

    public boolean validate(ValidationInformation info) {
        switch (info.getOperation()) {
            case BIND: 
            case UNBIND: {
                return this.validateBindAndUnbind();
            }
            case LOOKUP: {
                return this.validateLookup(info.getCandidate(), info.getInjectee());
            }
        }
        return false;
    }

    private static Permission getLookupPermission(String packName) {
        RuntimePermission retVal = new RuntimePermission(ACCESS_IN_PACKAGE + packName);
        return retVal;
    }

    private static List<Permission> getLookupPermissions(ActiveDescriptor<?> ad) {
        LinkedList<Permission> retVal = new LinkedList<Permission>();
        for (String contract : ad.getAdvertisedContracts()) {
            int index = contract.lastIndexOf(46);
            String packName = contract.substring(0, index);
            retVal.add(ValidatorImpl.getLookupPermission(packName));
        }
        return retVal;
    }

    private static boolean checkPerm(Permission p) {
        try {
            AccessController.checkPermission(p);
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
    }
}

