/*
 * Decompiled with CFR 0.152.
 */
package org.acme.security;

import java.io.File;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.ProtectionDomain;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.Operation;
import org.glassfish.hk2.api.Validator;

public class ValidatorImpl
implements Validator {
    private static final String ACCESS_IN_PACKAGE = "accessClassInPackage.";

    private boolean validateBindAndUnbind() {
        return ValidatorImpl.checkPerm(new AllPermission());
    }

    private boolean validateLookup(ActiveDescriptor<?> candidate, Injectee injectee) {
        Package p;
        if (injectee == null) {
            boolean retVal = ValidatorImpl.checkPerm(ValidatorImpl.getLookupPermission(candidate));
            if (!retVal) {
                System.out.println("candidate " + candidate + " LOOKUP FAILED the security check");
                File hello = new File("policy.txt");
                System.out.println("JRW(10) hello exists? " + hello.exists() + " at " + hello.getAbsolutePath());
            }
            return retVal;
        }
        Class injecteeClass = injectee.getInjecteeClass();
        ProtectionDomain pd = injecteeClass.getProtectionDomain();
        boolean retVal = pd.implies(ValidatorImpl.getLookupPermission((p = injecteeClass.getPackage()).getName()));
        if (!retVal) {
            System.out.println("candidate " + candidate + " injectee " + injectee + " LOOKUP FAILED the security check");
        }
        return retVal;
    }

    public boolean validate(Operation operation, ActiveDescriptor<?> candidate, Injectee injectee) {
        switch (operation) {
            case BIND: 
            case UNBIND: {
                return this.validateBindAndUnbind();
            }
            case LOOKUP: {
                return this.validateLookup(candidate, injectee);
            }
        }
        return false;
    }

    private static Permission getLookupPermission(String packName) {
        RuntimePermission retVal = new RuntimePermission(ACCESS_IN_PACKAGE + packName);
        return retVal;
    }

    private static Permission getLookupPermission(ActiveDescriptor<?> ad) {
        String fullImplClass = ad.getImplementation();
        int index = fullImplClass.lastIndexOf(46);
        String packName = fullImplClass.substring(0, index);
        return ValidatorImpl.getLookupPermission(packName);
    }

    private static boolean checkPerm(Permission p) {
        try {
            AccessController.checkPermission(p);
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
    }
}

