/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.utilities.cache.CacheUtilities;
import org.glassfish.hk2.utilities.cache.Computable;
import org.glassfish.hk2.utilities.cache.ComputationErrorException;
import org.glassfish.hk2.utilities.cache.WeakCARCache;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.xml.internal.Differences;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class UnkeyedDiff {
    private static final String UNKEYED_DEBUG_PROPERTY = "org.jvnet.hk2.properties.xml.unkeyed.debug";
    private static final boolean UNKEYED_DEBUG = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean(UnkeyedDiff.UNKEYED_DEBUG_PROPERTY);
        }
    });
    private final ReentrantLock lock = new ReentrantLock();
    private final List<BaseHK2JAXBBean> legacyList;
    private final List<BaseHK2JAXBBean> proposedList;
    private final ParentedModel parentModel;
    private final BaseHK2JAXBBean parent;
    private boolean computed = false;
    private Differences finalSolution = null;
    private HashMap<Integer, Differences> solution;
    private HashSet<Integer> usedLegacy;
    private HashSet<Integer> unusedLegacy;
    private HashMap<Integer, Differences> proposedAdds;
    private HashMap<Integer, SchrodingerSolution> quantumSolutions;

    public UnkeyedDiff(List<BaseHK2JAXBBean> legacy, List<BaseHK2JAXBBean> proposed, BaseHK2JAXBBean parent, ParentedModel parentModel) {
        if (legacy == null) {
            legacy = Collections.emptyList();
        }
        if (proposed == null) {
            proposed = Collections.emptyList();
        }
        this.legacyList = new ArrayList<BaseHK2JAXBBean>(legacy);
        this.proposedList = new ArrayList<BaseHK2JAXBBean>(proposed);
        this.parent = parent;
        this.parentModel = parentModel;
    }

    private static List<BaseHK2JAXBBean> asList(Object[] a) {
        if (a == null) {
            return Collections.emptyList();
        }
        ArrayList<BaseHK2JAXBBean> retVal = new ArrayList<BaseHK2JAXBBean>(a.length);
        for (Object o : a) {
            retVal.add((BaseHK2JAXBBean)o);
        }
        return retVal;
    }

    public UnkeyedDiff(Object[] legacy, Object[] proposed, BaseHK2JAXBBean parent, ParentedModel parentModel) {
        this(UnkeyedDiff.asList(legacy), UnkeyedDiff.asList(proposed), parent, parentModel);
    }

    public Differences compute() {
        this.lock.lock();
        try {
            if (this.computed) {
                Differences differences = this.finalSolution;
                return differences;
            }
            Differences retVal = null;
            try {
                retVal = this.internalCompute();
            }
            finally {
                if (retVal != null) {
                    this.finalSolution = retVal;
                    this.computed = true;
                }
            }
            Differences differences = retVal;
            return differences;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Differences internalCompute() {
        boolean diagonalChange;
        Differences retVal = new Differences();
        boolean needsChangeOfList = false;
        DifferenceTable table = new DifferenceTable();
        boolean bl = diagonalChange = !table.calculateDiagonal();
        if (!diagonalChange) {
            if (this.legacyList.size() == this.proposedList.size()) {
                return retVal;
            }
            if (this.legacyList.size() < this.proposedList.size()) {
                for (int lcv = this.legacyList.size(); lcv < this.proposedList.size(); ++lcv) {
                    Differences.Difference d = new Differences.Difference(this.parent);
                    d.addAdd(this.parentModel.getChildXmlTag(), new Differences.AddData(this.proposedList.get(lcv), lcv));
                    retVal.addDifference(d);
                }
                return retVal;
            }
            for (int lcv = this.proposedList.size(); lcv < this.legacyList.size(); ++lcv) {
                String xmlTag = this.parentModel.getChildXmlTag();
                Differences.Difference d = new Differences.Difference(this.parent);
                d.addRemove(xmlTag, new Differences.RemoveData(xmlTag, lcv, this.legacyList.get(lcv)));
                retVal.addDifference(d);
            }
            return retVal;
        }
        this.initializeSolution();
        for (int lcv = 0; lcv < table.getDiagonalSize(); ++lcv) {
            Differences differences = table.getDiff(lcv, lcv);
            if (!differences.getDifferences().isEmpty()) continue;
            this.addSolution(lcv, lcv, differences);
        }
        for (int proposedIndex = 0; proposedIndex < this.proposedList.size(); ++proposedIndex) {
            Differences.Difference difference;
            if (this.solution.containsKey(proposedIndex)) {
                if (!UNKEYED_DEBUG) continue;
                Logger.getLogger().debug("Skipping proposedIndex " + proposedIndex + " since it has already has a solution");
                continue;
            }
            int currentBestDiffIndex = -1;
            Differences currentBestDiffs = null;
            for (int legacyIndex = 0; legacyIndex < this.legacyList.size(); ++legacyIndex) {
                if (this.usedLegacy.contains(legacyIndex)) {
                    if (!UNKEYED_DEBUG) continue;
                    Logger.getLogger().debug("Skipping legacyIndex " + legacyIndex + " for proposedIndex " + proposedIndex + " since it has already has already been used");
                    continue;
                }
                Differences currentDiffs = table.getDiff(legacyIndex, proposedIndex);
                if (currentBestDiffs != null && currentBestDiffs.getDifferenceCost() <= currentDiffs.getDifferenceCost()) continue;
                currentBestDiffs = currentDiffs;
                currentBestDiffIndex = legacyIndex;
                if (!currentDiffs.getDifferences().isEmpty()) continue;
                needsChangeOfList = true;
                break;
            }
            if (currentBestDiffs == null) {
                Differences addMeDifference = new Differences();
                difference = new Differences.Difference(this.parent);
                difference.addAdd(this.parentModel.getChildXmlTag(), new Differences.AddData(this.proposedList.get(proposedIndex), proposedIndex));
                addMeDifference.addDifference(difference);
                needsChangeOfList = true;
                this.addSolution(-1, proposedIndex, addMeDifference);
                continue;
            }
            if (currentBestDiffs.getDifferences().isEmpty()) {
                needsChangeOfList = true;
                Differences moveMeDifferences = new Differences();
                difference = new Differences.Difference(this.parent);
                difference.addMove(this.parentModel.getChildXmlTag(), new Differences.MoveData(currentBestDiffIndex, proposedIndex));
                moveMeDifferences.addDifference(difference);
                this.addSolution(currentBestDiffIndex, proposedIndex, moveMeDifferences);
                continue;
            }
            BaseHK2JAXBBean currentProposed = this.proposedList.get(proposedIndex);
            Differences proposedAdd = this.proposedAdds.get(proposedIndex);
            if (proposedAdd == null) {
                proposedAdd = new Differences();
                Differences.Difference d = new Differences.Difference(this.parent);
                d.addAdd(this.parentModel.getChildXmlTag(), new Differences.AddData(currentProposed, proposedIndex));
                proposedAdd.addDifference(d);
                this.proposedAdds.put(proposedIndex, proposedAdd);
            }
            SchrodingerSolution sd = new SchrodingerSolution(currentBestDiffIndex, currentBestDiffs, proposedAdd);
            this.quantumSolutions.put(proposedIndex, sd);
        }
        for (Map.Entry<Integer, SchrodingerSolution> entry : this.quantumSolutions.entrySet()) {
            int proposedIndex = entry.getKey();
            SchrodingerSolution sd = entry.getValue();
            int legacyIndex = sd.legacyIndexOfDiff;
            if (this.usedLegacy.contains(legacyIndex)) {
                needsChangeOfList = true;
                this.addSolution(-1, proposedIndex, sd.proposedAddDifference);
                continue;
            }
            if (this.unusedLegacy.contains(legacyIndex)) {
                BaseHK2JAXBBean legacy = this.legacyList.get(legacyIndex);
                int removeCost = Utilities.calculateAddCost(legacy);
                int totalAddCost = removeCost + sd.proposedAddDifference.getDifferenceCost();
                if (totalAddCost >= sd.legacyDifference.getDifferenceCost()) {
                    this.addSolution(legacyIndex, proposedIndex, sd.legacyDifference);
                    continue;
                }
                needsChangeOfList = true;
                this.addSolution(-1, proposedIndex, sd.proposedAddDifference);
                continue;
            }
            throw new AssertionError((Object)"Should not be able to get here");
        }
        for (Differences diffs : this.solution.values()) {
            retVal.merge(diffs);
        }
        for (Integer legacyRemoveIndex : this.unusedLegacy) {
            Differences.Difference d = new Differences.Difference(this.parent);
            d.addRemove(this.parentModel.getChildXmlTag(), new Differences.RemoveData(this.parentModel.getChildXmlTag(), legacyRemoveIndex, this.legacyList.get(legacyRemoveIndex)));
            retVal.addDifference(d);
        }
        if (UNKEYED_DEBUG) {
            Logger.getLogger().debug("needsChangeOfList=" + needsChangeOfList + " with outcome " + retVal);
        }
        return retVal;
    }

    private void initializeSolution() {
        this.solution = new HashMap();
        this.usedLegacy = new HashSet();
        this.unusedLegacy = new HashSet();
        for (int lcv = 0; lcv < this.legacyList.size(); ++lcv) {
            this.unusedLegacy.add(lcv);
        }
        this.proposedAdds = new HashMap();
        this.quantumSolutions = new HashMap();
    }

    private void addSolution(int legacyIndex, int proposedIndex, Differences minimum) {
        this.solution.put(proposedIndex, minimum);
        if (legacyIndex >= 0) {
            this.usedLegacy.add(legacyIndex);
            this.unusedLegacy.remove(legacyIndex);
        }
    }

    private class DifferenceTable {
        private final int min;
        private final WeakCARCache<TableKey, Differences> table;

        private DifferenceTable() {
            this.min = Math.min(UnkeyedDiff.this.legacyList.size(), UnkeyedDiff.this.proposedList.size());
            int tableSize = UnkeyedDiff.this.legacyList.size() * UnkeyedDiff.this.proposedList.size();
            this.table = CacheUtilities.createWeakCARCache((Computable)new DifferenceMaker(), (int)tableSize, (boolean)false);
        }

        private boolean calculateDiagonal() {
            boolean theSame = true;
            for (int lcv = 0; lcv < this.min; ++lcv) {
                TableKey diagonalKey = new TableKey(lcv, lcv);
                Differences differences = (Differences)this.table.compute((Object)diagonalKey);
                if (differences.getDifferences().isEmpty()) continue;
                theSame = false;
            }
            return theSame;
        }

        private Differences getDiff(int legacyIndex, int proposedIndex) {
            return (Differences)this.table.compute((Object)new TableKey(legacyIndex, proposedIndex));
        }

        private int getDiagonalSize() {
            return this.min;
        }

        public String toString() {
            return "DifferenceTable(min=" + this.min + " legacySize=" + UnkeyedDiff.this.legacyList.size() + " proposedSize=" + UnkeyedDiff.this.proposedList.size() + "," + System.identityHashCode(this) + ")";
        }
    }

    private static class SchrodingerSolution {
        private final int legacyIndexOfDiff;
        private final Differences legacyDifference;
        private final Differences proposedAddDifference;

        private SchrodingerSolution(int legacyIndexOfDiff, Differences legacyDifference, Differences proposedAddDifference) {
            this.legacyIndexOfDiff = legacyIndexOfDiff;
            this.legacyDifference = legacyDifference;
            this.proposedAddDifference = proposedAddDifference;
        }

        public String toString() {
            return "SchrodingerSolution(" + this.legacyIndexOfDiff + "," + this.legacyDifference + "," + this.proposedAddDifference + "," + System.identityHashCode(this) + ")";
        }
    }

    private static class TableKey {
        private final int legacyIndex;
        private final int proposedIndex;
        private final int hash;

        private TableKey(int legacyIndex, int proposedIndex) {
            this.legacyIndex = legacyIndex;
            this.proposedIndex = proposedIndex;
            this.hash = legacyIndex ^ proposedIndex;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof TableKey)) {
                return false;
            }
            TableKey other = (TableKey)o;
            return other.legacyIndex == this.legacyIndex && other.proposedIndex == this.proposedIndex;
        }

        public String toString() {
            return "TableKey(" + this.legacyIndex + "," + this.proposedIndex + "," + System.identityHashCode(this) + ")";
        }
    }

    private class DifferenceMaker
    implements Computable<TableKey, Differences> {
        private DifferenceMaker() {
        }

        public Differences compute(TableKey key) throws ComputationErrorException {
            BaseHK2JAXBBean legacyBean = UnkeyedDiff.this.legacyList.get(key.legacyIndex);
            BaseHK2JAXBBean proposedBean = UnkeyedDiff.this.proposedList.get(key.proposedIndex);
            Differences retVal = Utilities.getDiff(legacyBean, proposedBean);
            return retVal;
        }

        public String toString() {
            return "DifferenceMaker(" + System.identityHashCode(this) + ")";
        }
    }
}

