/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.xml.internal.AliasType;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.Format;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ModelPropertyType;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.QNameUtilities;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.clazz.MethodAltMethodImpl;
import org.glassfish.hk2.xml.spi.Model;

public class ModelImpl
implements Model {
    private static final long serialVersionUID = 752816761552710497L;
    private final ReentrantLock lock = new ReentrantLock();
    private static final ReentrantLock slock = new ReentrantLock();
    private String originalInterface;
    private volatile Class<?> originalInterfaceAsClass;
    private String translatedClass;
    private volatile Class<?> translatedClassAsClass;
    private QName rootName;
    private final Map<QName, ParentedModel> childrenByName = new LinkedHashMap<QName, ParentedModel>();
    private final Map<QName, ChildDataModel> nonChildProperty = new LinkedHashMap<QName, ChildDataModel>();
    private final Map<QName, ChildDescriptor> allChildren = new LinkedHashMap<QName, ChildDescriptor>();
    private QName keyProperty;
    private Set<QName> unKeyedChildren = null;
    private Set<QName> keyedChildren = null;
    private transient JAUtilities jaUtilities = null;
    private ClassLoader myLoader;
    private Map<String, String> keyToJavaNameMap = null;
    private Set<String> allXmlWrappers;
    private String valuePropertyNamespace;
    private String valueProperty;
    private ChildDataModel valueData;

    public ModelImpl() {
    }

    public ModelImpl(String originalInterface, String translatedClass) {
        this.originalInterface = originalInterface;
        this.translatedClass = translatedClass;
    }

    public void setRootName(QName root) {
        this.rootName = root;
    }

    public void setRootName(String rootNamespace, String rootName) {
        this.rootName = QNameUtilities.createQName(rootNamespace, rootName);
    }

    public void setKeyProperty(QName qName) {
        String namespace = QNameUtilities.getNamespace(qName);
        String name = qName.getLocalPart();
        this.setKeyProperty(namespace, name);
    }

    public void setKeyProperty(String keyNamespace, String keyProperty) {
        this.keyProperty = QNameUtilities.createQName(keyNamespace, keyProperty);
    }

    public void addChild(String childInterface, String namespace, String xmlTag, String xmlAlias, ChildType childType, String givenDefault, AliasType aliased, String childWrapperTag, String adapter, boolean required, String originalMethodName) {
        ParentedModel pm = new ParentedModel(childInterface, namespace, xmlTag, xmlAlias, childType, givenDefault, aliased, childWrapperTag, adapter, required, originalMethodName);
        this.childrenByName.put(QNameUtilities.createQName(namespace, xmlTag), pm);
        this.allChildren.put(QNameUtilities.createQName(namespace, xmlTag), new ChildDescriptor(pm));
    }

    public void addNonChild(QName qName, String defaultValue, String childType, String childListType, boolean isReference, Format format, AliasType aliasType, String aliasOf, boolean required, String originalMethodName) {
        String namespace = QNameUtilities.getNamespace(qName);
        String xmlTag = qName.getLocalPart();
        this.addNonChild(namespace, xmlTag, defaultValue, childType, childListType, isReference, format, aliasType, aliasOf, required, originalMethodName);
    }

    public void addNonChild(String namespace, String xmlTag, String defaultValue, String childType, String childListType, boolean isReference, Format format, AliasType aliasType, String aliasOf, boolean required, String originalMethodName) {
        ChildDataModel cdm = new ChildDataModel(childType, childListType, defaultValue, isReference, format, aliasType, aliasOf, required, originalMethodName);
        this.nonChildProperty.put(QNameUtilities.createQName(namespace, xmlTag), cdm);
        this.allChildren.put(QNameUtilities.createQName(namespace, xmlTag), new ChildDescriptor(cdm));
        if (Format.VALUE.equals((Object)format)) {
            this.valuePropertyNamespace = namespace;
            this.valueProperty = xmlTag;
            this.valueData = cdm;
        }
    }

    @Override
    public String getOriginalInterface() {
        return this.originalInterface;
    }

    @Override
    public String getTranslatedClass() {
        return this.translatedClass;
    }

    @Override
    public QName getRootName() {
        return this.rootName;
    }

    @Override
    public QName getKeyProperty() {
        return this.keyProperty;
    }

    public Map<QName, ParentedModel> getChildrenByName() {
        return this.childrenByName;
    }

    public Map<QName, ChildDataModel> getNonChildProperties() {
        return this.nonChildProperty;
    }

    public Map<QName, ChildDescriptor> getAllChildrenDescriptors() {
        return this.allChildren;
    }

    public String getValuePropertyNamespace() {
        return this.valuePropertyNamespace;
    }

    public String getValueProperty() {
        return this.valueProperty;
    }

    public ChildDataModel getValueData() {
        return this.valueData;
    }

    public Set<String> getAllXmlWrappers() {
        slock.lock();
        try {
            if (this.allXmlWrappers != null) {
                Set<String> set = this.allXmlWrappers;
                return set;
            }
            this.allXmlWrappers = new LinkedHashSet<String>();
            for (ParentedModel pm : this.childrenByName.values()) {
                if (pm.getXmlWrapperTag() == null) continue;
                this.allXmlWrappers.add(pm.getXmlWrapperTag());
            }
            Set<String> set = this.allXmlWrappers;
            return set;
        }
        finally {
            slock.unlock();
        }
    }

    public ChildDescriptor getChildDescriptor(QName xmlTag) {
        return this.allChildren.get(xmlTag);
    }

    public Set<QName> getUnKeyedChildren() {
        slock.lock();
        try {
            if (this.unKeyedChildren != null) {
                Set<QName> set = this.unKeyedChildren;
                return set;
            }
            this.unKeyedChildren = new HashSet<QName>();
            for (Map.Entry<QName, ParentedModel> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChildModel().getKeyProperty() != null) continue;
                this.unKeyedChildren.add(entry.getKey());
            }
            Set<QName> set = this.unKeyedChildren;
            return set;
        }
        finally {
            slock.unlock();
        }
    }

    public Set<QName> getKeyedChildren() {
        slock.lock();
        try {
            if (this.keyedChildren != null) {
                Set<QName> set = this.keyedChildren;
                return set;
            }
            this.keyedChildren = new HashSet<QName>();
            for (Map.Entry<QName, ParentedModel> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChildModel().getKeyProperty() == null) continue;
                this.keyedChildren.add(entry.getKey());
            }
            Set<QName> set = this.keyedChildren;
            return set;
        }
        finally {
            slock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJAUtilities(JAUtilities jaUtilities, ClassLoader myLoader) {
        slock.lock();
        try {
            if (this.jaUtilities != null) {
                return;
            }
            this.jaUtilities = jaUtilities;
            this.myLoader = myLoader;
            for (ParentedModel pm : this.childrenByName.values()) {
                pm.setRuntimeInformation(jaUtilities, myLoader);
            }
            for (ChildDataModel cdm : this.nonChildProperty.values()) {
                cdm.setLoader(myLoader);
            }
        }
        finally {
            slock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultChildValue(String propNamespace, String propName) {
        QName propQName = QNameUtilities.createQName(propNamespace, propName);
        slock.lock();
        try {
            ChildDataModel cd = this.nonChildProperty.get(propQName);
            if (cd == null) {
                String string = null;
                return string;
            }
            String string = cd.getDefaultAsString();
            return string;
        }
        finally {
            slock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelPropertyType getModelPropertyType(String propNamespace, String propName) {
        QName propQName = QNameUtilities.createQName(propNamespace, propName);
        slock.lock();
        try {
            if (this.nonChildProperty.containsKey(propQName)) {
                ModelPropertyType modelPropertyType = ModelPropertyType.FLAT_PROPERTY;
                return modelPropertyType;
            }
            if (this.childrenByName.containsKey(propQName)) {
                ModelPropertyType modelPropertyType = ModelPropertyType.TREE_ROOT;
                return modelPropertyType;
            }
            ModelPropertyType modelPropertyType = ModelPropertyType.UNKNOWN;
            return modelPropertyType;
        }
        finally {
            slock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getNonChildType(String propNamespace, String propName) {
        QName propQName = QNameUtilities.createQName(propNamespace, propName);
        slock.lock();
        try {
            ChildDataModel cd = this.nonChildProperty.get(propQName);
            if (cd == null) {
                Class<?> clazz = null;
                return clazz;
            }
            Class<?> clazz = cd.getChildTypeAsClass();
            return clazz;
        }
        finally {
            slock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentedModel getChild(String propNamespace, String propName) {
        QName propQName = QNameUtilities.createQName(propNamespace, propName);
        slock.lock();
        try {
            ParentedModel parentedModel = this.childrenByName.get(propQName);
            return parentedModel;
        }
        finally {
            slock.unlock();
        }
    }

    @Override
    public Class<?> getOriginalInterfaceAsClass() {
        if (this.originalInterfaceAsClass != null) {
            return this.originalInterfaceAsClass;
        }
        slock.lock();
        try {
            if (this.originalInterfaceAsClass != null) {
                Class<?> clazz = this.originalInterfaceAsClass;
                return clazz;
            }
            this.originalInterfaceAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.originalInterface);
            Class<?> clazz = this.originalInterfaceAsClass;
            return clazz;
        }
        finally {
            slock.unlock();
        }
    }

    @Override
    public Class<?> getProxyAsClass() {
        if (this.translatedClassAsClass != null) {
            return this.translatedClassAsClass;
        }
        slock.lock();
        try {
            if (this.translatedClassAsClass != null) {
                Class<?> clazz = this.translatedClassAsClass;
                return clazz;
            }
            this.translatedClassAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.translatedClass);
            Class<?> clazz = this.translatedClassAsClass;
            return clazz;
        }
        finally {
            slock.unlock();
        }
    }

    public Collection<ParentedModel> getAllChildren() {
        slock.lock();
        try {
            Collection<ParentedModel> collection = Collections.unmodifiableCollection(this.childrenByName.values());
            return collection;
        }
        finally {
            slock.unlock();
        }
    }

    public Map<QName, ParentedModel> getChildrenProperties() {
        slock.lock();
        try {
            Map<QName, ParentedModel> map = Collections.unmodifiableMap(this.childrenByName);
            return map;
        }
        finally {
            slock.unlock();
        }
    }

    public Map<QName, ChildDataModel> getAllAttributeChildren() {
        LinkedHashMap<QName, ChildDataModel> retVal = new LinkedHashMap<QName, ChildDataModel>();
        for (Map.Entry<QName, ChildDataModel> candidate : this.nonChildProperty.entrySet()) {
            QName xmlKey = candidate.getKey();
            ChildDataModel childDataModel = candidate.getValue();
            if (!Format.ATTRIBUTE.equals((Object)childDataModel.getFormat())) continue;
            retVal.put(xmlKey, childDataModel);
        }
        return retVal;
    }

    public Map<QName, ChildDescriptor> getAllElementChildren() {
        LinkedHashMap<QName, ChildDescriptor> retVal = new LinkedHashMap<QName, ChildDescriptor>();
        for (Map.Entry<QName, ChildDescriptor> candidate : this.allChildren.entrySet()) {
            QName xmlKey = candidate.getKey();
            ChildDescriptor childDescriptor = candidate.getValue();
            if (childDescriptor.getParentedModel() != null) {
                retVal.put(xmlKey, childDescriptor);
                continue;
            }
            ChildDataModel childDataModel = childDescriptor.getChildDataModel();
            if (!Format.ELEMENT.equals((Object)childDataModel.getFormat())) continue;
            retVal.put(xmlKey, childDescriptor);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaNameFromKey(String key, ClassReflectionHelper reflectionHelper) {
        this.lock.lock();
        try {
            String result;
            if (this.keyToJavaNameMap == null) {
                this.keyToJavaNameMap = new LinkedHashMap<String, String>();
            }
            if ((result = this.keyToJavaNameMap.get(key)) != null) {
                String string = result;
                return string;
            }
            if (reflectionHelper == null) {
                String string = null;
                return string;
            }
            Class<?> originalInterface = this.getOriginalInterfaceAsClass();
            for (MethodWrapper wrapper : reflectionHelper.getAllMethods(originalInterface)) {
                String xmlName;
                Method m = wrapper.getMethod();
                XmlElement element = m.getAnnotation(XmlElement.class);
                if (element == null) {
                    XmlAttribute attribute = m.getAnnotation(XmlAttribute.class);
                    if (attribute == null) continue;
                    xmlName = attribute.name();
                } else {
                    xmlName = element.name();
                }
                String javaName = ModelImpl.getJavaNameFromGetterOrSetter(m, reflectionHelper);
                String keyName = "##default".equals(xmlName) ? javaName : xmlName;
                if (!key.equals(keyName)) continue;
                this.keyToJavaNameMap.put(key, javaName);
                String string = javaName;
                return string;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String getJavaNameFromGetterOrSetter(Method m, ClassReflectionHelper reflectionHelper) {
        MethodAltMethodImpl alt = new MethodAltMethodImpl(m, reflectionHelper);
        String retVal = Utilities.isGetter(alt);
        if (retVal != null) {
            return retVal;
        }
        return Utilities.isSetter(alt);
    }

    public int hashCode() {
        return this.translatedClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ModelImpl)) {
            return false;
        }
        return this.translatedClass.equals(((ModelImpl)o).getTranslatedClass());
    }

    public String toString() {
        return "ModelImpl(interface=" + this.originalInterface + ",class=" + this.translatedClass + ",root=" + this.rootName + ",keyProperty=" + this.keyProperty + ",valuePropertyNamespace=" + this.valuePropertyNamespace + ",valueProperty=" + this.valueProperty + "," + System.identityHashCode(this) + ")";
    }
}

