/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.QNameUtilities;
import org.glassfish.hk2.xml.jaxb.internal.NamespaceBeanLikeMap;

public class NamespaceBeanLikeMapImpl
implements NamespaceBeanLikeMap,
Serializable {
    private static final long serialVersionUID = 7351909351649012181L;
    private Map<String, Map<String, Object>> namespaceMap = new LinkedHashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> backupMap;

    public NamespaceBeanLikeMapImpl() {
        this.namespaceMap.put("##default", new LinkedHashMap());
    }

    private static Map<String, Map<String, Object>> deepCopyNamespaceBeanLikeMaps(Map<String, Map<String, Object>> copyMe) {
        LinkedHashMap<String, Map<String, Object>> retVal = new LinkedHashMap<String, Map<String, Object>>();
        if (copyMe == null) {
            return retVal;
        }
        for (Map.Entry<String, Map<String, Object>> entry : copyMe.entrySet()) {
            String namespace = entry.getKey();
            Map<String, Object> blm = entry.getValue();
            retVal.put(namespace, new LinkedHashMap<String, Object>(blm));
        }
        return retVal;
    }

    @Override
    public Object getValue(String namespace, String key) {
        Map<String, Object> nMap = this.namespaceMap.get(namespace = QNameUtilities.fixNamespace(namespace));
        if (nMap == null) {
            return null;
        }
        return nMap.get(key);
    }

    @Override
    public void setValue(String namespace, String key, Object value) {
        Map<String, Object> narrowedMap = this.namespaceMap.get(namespace = QNameUtilities.fixNamespace(namespace));
        if (narrowedMap == null) {
            narrowedMap = new LinkedHashMap<String, Object>();
            this.namespaceMap.put(namespace, narrowedMap);
        }
        narrowedMap.put(key, value);
    }

    @Override
    public boolean isSet(String namespace, String key) {
        Map<String, Object> narrowedMap = this.namespaceMap.get(namespace = QNameUtilities.fixNamespace(namespace));
        if (narrowedMap == null) {
            return false;
        }
        return narrowedMap.containsKey(key);
    }

    @Override
    public void backup() {
        if (this.backupMap != null) {
            return;
        }
        this.backupMap = NamespaceBeanLikeMapImpl.deepCopyNamespaceBeanLikeMaps(this.namespaceMap);
    }

    @Override
    public void restoreBackup(boolean drop) {
        try {
            if (this.backupMap == null) {
                return;
            }
            if (drop) {
                return;
            }
            this.namespaceMap = this.backupMap;
        }
        finally {
            this.backupMap = null;
        }
    }

    @Override
    public Map<String, Object> getBeanLikeMap(Map<String, String> namespaceToPrefixMap) {
        LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Map<String, Object>> outerEntry : this.namespaceMap.entrySet()) {
            String prefix;
            String namespace = outerEntry.getKey();
            Map<String, Object> blm = outerEntry.getValue();
            boolean addNamespace = !"##default".equals(namespace);
            String string = prefix = addNamespace ? namespaceToPrefixMap.get(namespace) : null;
            if (addNamespace && prefix == null) continue;
            for (Map.Entry<String, Object> innerEntry : blm.entrySet()) {
                Object value = innerEntry.getValue();
                String key = addNamespace ? prefix + ":" + innerEntry.getKey() : innerEntry.getKey();
                retVal.put(key, value);
            }
        }
        return retVal;
    }

    @Override
    public void shallowCopy(NamespaceBeanLikeMap copyFrom, ModelImpl copyModel, boolean copyReferences) {
        for (Map.Entry<String, Map<String, Object>> outerEntry : copyFrom.getNamespaceBeanLikeMap().entrySet()) {
            String copyNamespace = outerEntry.getKey();
            Map<String, Object> copyBeanLikeMap = outerEntry.getValue();
            for (Map.Entry<String, Object> entrySet : copyBeanLikeMap.entrySet()) {
                String xmlTag = entrySet.getKey();
                QName childQName = QNameUtilities.createQName(copyNamespace, xmlTag);
                if (copyModel.getKeyedChildren().contains(childQName) || copyModel.getUnKeyedChildren().contains(childQName)) continue;
                ChildDataModel cdm = copyModel.getNonChildProperties().get(childQName);
                if (!copyReferences && cdm != null && cdm.isReference()) continue;
                this.setValue(copyNamespace, xmlTag, entrySet.getValue());
            }
        }
    }

    @Override
    public Map<String, Map<String, Object>> getNamespaceBeanLikeMap() {
        return this.namespaceMap;
    }

    @Override
    public Map<QName, Object> getQNameMap() {
        LinkedHashMap<QName, Object> retVal = new LinkedHashMap<QName, Object>();
        for (Map.Entry<String, Map<String, Object>> outerEntry : this.namespaceMap.entrySet()) {
            String namespace = outerEntry.getKey();
            Map<String, Object> innerMap = outerEntry.getValue();
            for (Map.Entry<String, Object> innerEntry : innerMap.entrySet()) {
                QName key = QNameUtilities.createQName(namespace, innerEntry.getKey());
                Object value = innerEntry.getValue();
                retVal.put(key, value);
            }
        }
        return retVal;
    }

    public String toString() {
        return "NamespaceBeanLikeMapImpl(" + System.identityHashCode(this) + ")";
    }
}

