/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.xml.api.annotations.PluralOf;
import org.glassfish.hk2.xml.internal.Format;
import org.glassfish.hk2.xml.internal.MethodType;
import org.glassfish.hk2.xml.internal.NameInformation;
import org.glassfish.hk2.xml.internal.QNameUtilities;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlElementData;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.clazz.AnnotationAltAnnotationImpl;

public class GeneratorUtilities {
    private static final String XML_VALUE_LOCAL_PART = "##XmlValue";
    public static final String XML_ANY_ATTRIBUTE_LOCAL_PART = "##XmlAnyAttribute";

    public static QName convertXmlRootElementName(AltAnnotation root, AltClass clazz) {
        String namespace = root.getStringValue("namespace");
        String rootName = root.getStringValue("name");
        if (!"##default".equals(rootName)) {
            return QNameUtilities.createQName(namespace, rootName);
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        String localPart = sb.toString();
        return QNameUtilities.createQName(namespace, localPart);
    }

    private static boolean isSpecifiedReference(AltMethod method) {
        AltAnnotation customAnnotation = method.getAnnotation(XmlIDREF.class.getName());
        return customAnnotation != null;
    }

    private static void checkOnlyOne(AltClass convertMe, AltMethod method, AltAnnotation aAnnotation, AltAnnotation bAnnotation) {
        if (aAnnotation != null && bAnnotation != null) {
            throw new IllegalArgumentException("The method " + method + " of " + convertMe + " has both the annotation " + aAnnotation + " and the annotation " + bAnnotation + " which is illegal");
        }
    }

    public static NameInformation getXmlNameMap(AltClass convertMe) {
        LinkedHashMap<String, XmlElementData> xmlNameMap = new LinkedHashMap<String, XmlElementData>();
        LinkedHashSet<String> unmappedNames = new LinkedHashSet<String>();
        LinkedHashMap<String, String> addMethodToVariableMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> removeMethodToVariableMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> lookupMethodToVariableMap = new LinkedHashMap<String, String>();
        LinkedHashSet<String> referenceSet = new LinkedHashSet<String>();
        LinkedHashMap<String, List<XmlElementData>> aliasMap = new LinkedHashMap<String, List<XmlElementData>>();
        XmlElementData valueData = null;
        XmlElementData xmlAnyAttributeData = null;
        boolean hasAnElement = false;
        for (AltMethod originalMethod : convertMe.getMethods()) {
            String defaultValue;
            String xmlElementWrapperName;
            String originalMethodName = originalMethod.getName();
            String setterVariable = Utilities.isSetter(originalMethod);
            if (setterVariable == null && (setterVariable = Utilities.isGetter(originalMethod)) == null) continue;
            if (GeneratorUtilities.isSpecifiedReference(originalMethod)) {
                referenceSet.add(setterVariable);
            }
            AltAnnotation pluralOf = null;
            AltAnnotation xmlElement = originalMethod.getAnnotation(XmlElement.class.getName());
            AltAnnotation xmlElements = originalMethod.getAnnotation(XmlElements.class.getName());
            AltAnnotation xmlElementWrapper = originalMethod.getAnnotation(XmlElementWrapper.class.getName());
            AltAnnotation xmlAttribute = originalMethod.getAnnotation(XmlAttribute.class.getName());
            AltAnnotation xmlValue = originalMethod.getAnnotation(XmlValue.class.getName());
            AltAnnotation xmlAnyAttribute = originalMethod.getAnnotation(XmlAnyAttribute.class.getName());
            String string = xmlElementWrapperName = xmlElementWrapper == null ? null : xmlElementWrapper.getStringValue("name");
            if (xmlElementWrapperName != null && xmlElementWrapperName.isEmpty()) {
                xmlElementWrapperName = setterVariable;
            }
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElement, xmlElements);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElement, xmlAttribute);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElements, xmlAttribute);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElement, xmlValue);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElements, xmlValue);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlAttribute, xmlValue);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElement, xmlAnyAttribute);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlElements, xmlAnyAttribute);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlAttribute, xmlAnyAttribute);
            GeneratorUtilities.checkOnlyOne(convertMe, originalMethod, xmlValue, xmlAnyAttribute);
            if (xmlElements != null) {
                hasAnElement = true;
                pluralOf = originalMethod.getAnnotation(PluralOf.class.getName());
                defaultValue = "\u0000";
                xmlNameMap.put(setterVariable, new XmlElementData("", setterVariable, setterVariable, defaultValue, Format.ELEMENT, null, true, xmlElementWrapperName, false, originalMethodName));
                String aliasName = setterVariable;
                AltAnnotation[] allXmlElements = xmlElements.getAnnotationArrayValue("value");
                ArrayList<XmlElementData> aliases = new ArrayList<XmlElementData>(allXmlElements.length);
                aliasMap.put(setterVariable, aliases);
                for (AltAnnotation allXmlElement : allXmlElements) {
                    boolean allXmlElementTypeInterface;
                    defaultValue = allXmlElement.getStringValue("defaultValue");
                    String allXmlElementNamespace = allXmlElement.getStringValue("namespace");
                    String allXmlElementName = allXmlElement.getStringValue("name");
                    boolean allXmlElementRequired = allXmlElement.getBooleanValue("required");
                    AltClass allXmlElementType = (AltClass)allXmlElement.getAnnotationValues().get("type");
                    String allXmlElementTypeName = allXmlElementType == null ? null : allXmlElementType.getName();
                    boolean bl = allXmlElementTypeInterface = allXmlElementType == null ? true : allXmlElementType.isInterface();
                    if ("##default".equals(allXmlElementName)) {
                        throw new IllegalArgumentException("The name field of an XmlElement inside an XmlElements must have a specified name");
                    }
                    aliases.add(new XmlElementData(allXmlElementNamespace, allXmlElementName, aliasName, defaultValue, Format.ELEMENT, allXmlElementTypeName, allXmlElementTypeInterface, xmlElementWrapperName, allXmlElementRequired, originalMethodName));
                }
            } else if (xmlElement != null) {
                hasAnElement = true;
                pluralOf = originalMethod.getAnnotation(PluralOf.class.getName());
                defaultValue = xmlElement.getStringValue("defaultValue");
                String namespace = xmlElement.getStringValue("namespace");
                String name = xmlElement.getStringValue("name");
                boolean required = xmlElement.getBooleanValue("required");
                if ("##default".equals(name)) {
                    xmlNameMap.put(setterVariable, new XmlElementData(namespace, setterVariable, setterVariable, defaultValue, Format.ELEMENT, null, true, xmlElementWrapperName, required, originalMethodName));
                } else {
                    xmlNameMap.put(setterVariable, new XmlElementData(namespace, name, name, defaultValue, Format.ELEMENT, null, true, xmlElementWrapperName, required, originalMethodName));
                }
            } else if (xmlAttribute != null) {
                String namespace = xmlAttribute.getStringValue("namespace");
                String name = xmlAttribute.getStringValue("name");
                boolean required = xmlAttribute.getBooleanValue("required");
                if ("##default".equals(name)) {
                    xmlNameMap.put(setterVariable, new XmlElementData(namespace, setterVariable, setterVariable, "\u0000", Format.ATTRIBUTE, null, true, xmlElementWrapperName, required, originalMethodName));
                } else {
                    xmlNameMap.put(setterVariable, new XmlElementData(namespace, name, name, "\u0000", Format.ATTRIBUTE, null, true, xmlElementWrapperName, required, originalMethodName));
                }
            } else if (xmlValue != null) {
                if (valueData != null) {
                    throw new IllegalArgumentException("There may be only one XmlValue method on " + convertMe);
                }
                valueData = new XmlElementData("##default", XML_VALUE_LOCAL_PART, XML_VALUE_LOCAL_PART, null, Format.VALUE, null, false, xmlElementWrapperName, true, originalMethodName);
                xmlNameMap.put(setterVariable, valueData);
            } else if (xmlAnyAttribute != null) {
                if (xmlAnyAttributeData != null) {
                    throw new IllegalArgumentException("There may be only one XmlAnyAttribute method on " + convertMe);
                }
                xmlAnyAttributeData = new XmlElementData("##default", XML_ANY_ATTRIBUTE_LOCAL_PART, XML_ANY_ATTRIBUTE_LOCAL_PART, null, Format.ATTRIBUTE, null, false, xmlElementWrapperName, false, originalMethodName);
                xmlNameMap.put(setterVariable, xmlAnyAttributeData);
            } else {
                unmappedNames.add(setterVariable);
            }
            if (pluralOf == null) {
                pluralOf = new AnnotationAltAnnotationImpl(new PluralOfDefault(), null);
            }
            String unDecapitalizedVariable = originalMethod.getName().substring(3);
            addMethodToVariableMap.put(GeneratorUtilities.getMethodName(MethodType.ADD, unDecapitalizedVariable, pluralOf), setterVariable);
            removeMethodToVariableMap.put(GeneratorUtilities.getMethodName(MethodType.REMOVE, unDecapitalizedVariable, pluralOf), setterVariable);
            lookupMethodToVariableMap.put(GeneratorUtilities.getMethodName(MethodType.LOOKUP, unDecapitalizedVariable, pluralOf), setterVariable);
        }
        if (valueData != null && hasAnElement) {
            throw new IllegalArgumentException("A bean cannot both have XmlElements and XmlValue methods in " + convertMe);
        }
        LinkedHashSet<String> noXmlElementNames = new LinkedHashSet<String>();
        for (String unmappedName : unmappedNames) {
            if (xmlNameMap.containsKey(unmappedName)) continue;
            noXmlElementNames.add(unmappedName);
        }
        return new NameInformation(xmlNameMap, noXmlElementNames, addMethodToVariableMap, removeMethodToVariableMap, lookupMethodToVariableMap, referenceSet, aliasMap, valueData);
    }

    private static String getMethodName(MethodType methodType, String unDecapitalizedVariable, AltAnnotation instructions) {
        String retVal;
        switch (methodType) {
            case ADD: {
                retVal = instructions.getStringValue("add");
                break;
            }
            case REMOVE: {
                retVal = instructions.getStringValue("remove");
                break;
            }
            case LOOKUP: {
                retVal = instructions.getStringValue("lookup");
                break;
            }
            default: {
                throw new AssertionError((Object)"Only ADD, REMOVE and LOOKUP supported");
            }
        }
        if (!"*".equals(retVal)) {
            return retVal;
        }
        String pluralOf = instructions.getStringValue("value");
        if (!"*".equals(pluralOf)) {
            switch (methodType) {
                case ADD: {
                    return "add" + pluralOf;
                }
                case REMOVE: {
                    return "remove" + pluralOf;
                }
                case LOOKUP: {
                    return "lookup" + pluralOf;
                }
            }
            throw new AssertionError((Object)"Only add, remove and lookup supported");
        }
        if (unDecapitalizedVariable.endsWith("s")) {
            unDecapitalizedVariable = unDecapitalizedVariable.substring(0, unDecapitalizedVariable.length() - 1);
        }
        switch (methodType) {
            case ADD: {
                return "add" + unDecapitalizedVariable;
            }
            case REMOVE: {
                return "remove" + unDecapitalizedVariable;
            }
            case LOOKUP: {
                return "lookup" + unDecapitalizedVariable;
            }
        }
        throw new AssertionError((Object)"Only add, remove and lookup supported");
    }

    private static final class PluralOfDefault
    extends AnnotationLiteral<PluralOf>
    implements PluralOf {
        private static final long serialVersionUID = 4358923840720264176L;

        private PluralOfDefault() {
        }

        @Override
        public String value() {
            return "*";
        }

        @Override
        public String add() {
            return "*";
        }

        @Override
        public String remove() {
            return "*";
        }

        @Override
        public String lookup() {
            return "*";
        }
    }
}

