/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.tools;

import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.glassfish.hk2.xml.internal.Generator;
import org.glassfish.hk2.xml.internal.alt.papi.TypeElementAltClassImpl;

@SupportedAnnotationTypes(value={"org.glassfish.hk2.xml.api.annotations.Hk2XmlPreGenerate"})
public class Hk2XmlGenerator
extends AbstractProcessor {
    private volatile boolean initialized;
    private ClassPool defaultClassPool;
    private CtClass superClazz;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHk2XmlGenerator() {
        if (this.initialized) {
            return;
        }
        Hk2XmlGenerator hk2XmlGenerator = this;
        synchronized (hk2XmlGenerator) {
            if (this.initialized) {
                return;
            }
            this.defaultClassPool = new ClassPool(true);
            ClassLoader localLoader = this.getClass().getClassLoader();
            if (!(localLoader instanceof URLClassLoader)) {
                throw new RuntimeException("Unknown classloader: " + localLoader);
            }
            URLClassLoader urlLoader = (URLClassLoader)localLoader;
            for (URL url : urlLoader.getURLs()) {
                URI uri;
                try {
                    uri = url.toURI();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                File asFile = new File(uri);
                if (!asFile.exists() || !asFile.canRead()) continue;
                try {
                    this.defaultClassPool.appendClassPath(asFile.getAbsolutePath());
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.superClazz = this.defaultClassPool.get("org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean");
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> clazzes = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : clazzes) {
                if (!(element instanceof TypeElement)) continue;
                this.initializeHk2XmlGenerator();
                TypeElement clazz = (TypeElement)element;
                TypeElementAltClassImpl altClass = new TypeElementAltClassImpl(clazz, this.processingEnv);
                try {
                    CtClass ctClass = Generator.generate(altClass, this.superClazz, this.defaultClassPool);
                    String ctClassName = ctClass.getName();
                    JavaFileObject jfo = filer.createClassFile(ctClassName, element);
                    OutputStream outputStream = jfo.openOutputStream();
                    DataOutputStream dataOutputStream = null;
                    try {
                        dataOutputStream = new DataOutputStream(outputStream);
                        ctClass.toBytecode(dataOutputStream);
                    }
                    finally {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                        outputStream.close();
                    }
                }
                catch (Throwable e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = "Exception of type " + e.getClass().getName();
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "While processing class: " + clazz.getQualifiedName() + " got exeption: " + msg);
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

