/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.utilities.general.GeneralUtilities;

public class ChildDataModel
implements Serializable {
    private static final long serialVersionUID = 208423310453044595L;
    private static final Map<String, Class<?>> TYPE_MAP = new HashMap();
    private final Object lock = new Object();
    private String childType;
    private String defaultAsString;
    private ClassLoader myLoader;
    private Class<?> childTypeAsClass;

    public ChildDataModel() {
    }

    public ChildDataModel(String childType, String defaultAsString) {
        this.childType = childType;
        this.defaultAsString = defaultAsString;
    }

    public String getChildType() {
        return this.childType;
    }

    public String getDefaultAsString() {
        return this.defaultAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader myLoader) {
        Object object = this.lock;
        synchronized (object) {
            this.myLoader = myLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getChildTypeAsClass() {
        Object object = this.lock;
        synchronized (object) {
            if (this.childTypeAsClass != null) {
                return this.childTypeAsClass;
            }
            this.childTypeAsClass = TYPE_MAP.get(this.childType);
            if (this.childTypeAsClass != null) {
                return this.childTypeAsClass;
            }
            this.childTypeAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childType);
            return this.childTypeAsClass;
        }
    }

    public String toString() {
        return "ChildDataModel(" + this.childType + "," + this.defaultAsString + ")";
    }

    static {
        TYPE_MAP.put("char", Character.TYPE);
        TYPE_MAP.put("byte", Byte.TYPE);
        TYPE_MAP.put("short", Short.TYPE);
        TYPE_MAP.put("int", Integer.TYPE);
        TYPE_MAP.put("float", Float.TYPE);
        TYPE_MAP.put("long", Long.TYPE);
        TYPE_MAP.put("double", Double.TYPE);
        TYPE_MAP.put("boolean", Boolean.TYPE);
    }
}

