/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.cache.internal;

import java.util.HashMap;
import org.glassfish.hk2.utilities.cache.LRUCache;

public class LRUCacheImpl<K, V>
extends LRUCache<K, V> {
    private final int maxCacheSize;
    private final HashMap<K, CacheEntry<K, V>> entries = new HashMap();
    private CacheEntry<K, V> first;
    private CacheEntry<K, V> last;

    public LRUCacheImpl(int maxCacheSize) {
        if (maxCacheSize <= 2) {
            throw new IllegalArgumentException();
        }
        this.maxCacheSize = maxCacheSize;
    }

    private void removeEntry(CacheEntry<K, V> removeMe) {
        CacheEntry previous = ((CacheEntry)removeMe).getPrevious();
        CacheEntry next = ((CacheEntry)removeMe).getNext();
        if (previous == null) {
            this.first = next;
        } else {
            previous.setNext(next);
        }
        if (next == null) {
            this.last = previous;
        } else {
            next.setPrevious(previous);
        }
        ((CacheEntry)removeMe).setNext(null);
        ((CacheEntry)removeMe).setPrevious(null);
    }

    private void addToFront(CacheEntry<K, V> addMe) {
        ((CacheEntry)addMe).setNext((CacheEntry)this.first);
        if (this.first != null) {
            ((CacheEntry)this.first).setPrevious((CacheEntry)addMe);
        }
        this.first = addMe;
        if (this.last == null) {
            this.last = addMe;
        }
    }

    @Override
    public synchronized V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        CacheEntry<K, V> entry = this.entries.get(key);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        this.addToFront(entry);
        return (V)((CacheEntry)entry).getValue();
    }

    @Override
    public synchronized void put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        CacheEntry addMe = new CacheEntry(value);
        addMe.setKey(key);
        this.entries.put(key, addMe);
        this.addToFront(addMe);
        if (this.entries.size() > this.maxCacheSize) {
            Object removeMe = ((CacheEntry)this.last).getKey();
            this.entries.remove(removeMe);
            this.removeEntry(this.last);
        }
    }

    @Override
    public synchronized void releaseCache() {
        this.entries.clear();
        this.first = null;
        this.last = null;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public String toString() {
        return "LRUCacheImpl(maxCacheSize=" + this.maxCacheSize + "," + System.identityHashCode(this) + ")";
    }

    private static class CacheEntry<K, V> {
        private K key;
        private final V value;
        private CacheEntry<K, V> next;
        private CacheEntry<K, V> previous;

        private CacheEntry(V value) {
            this.value = value;
        }

        private V getValue() {
            return this.value;
        }

        private CacheEntry<K, V> getNext() {
            return this.next;
        }

        private CacheEntry<K, V> getPrevious() {
            return this.previous;
        }

        private void setNext(CacheEntry<K, V> next) {
            this.next = next;
        }

        private void setPrevious(CacheEntry<K, V> previous) {
            this.previous = previous;
        }

        private void setKey(K key) {
            this.key = key;
        }

        private K getKey() {
            return this.key;
        }

        public String toString() {
            return "CacheEntry(" + this.key + "=" + this.value + "," + System.identityHashCode(this) + ")";
        }
    }
}

