/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.hk2;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.osgiadapter.OSGiDirectoryBasedRepository;
import org.jvnet.hk2.osgiadapter.OSGiFactoryImpl;
import org.osgi.framework.Version;

public class PackageAnalyser {
    public Set<Bundle> bundles;
    private Logger logger;
    static final char QUOTE = '\"';
    static final char COMMA = ',';
    static final char SEMICOLON = ';';
    static final char COLON = ':';
    static final char EQUALS = '=';
    private Repository moduleRepository;

    public PackageAnalyser(Repository moduleRepository) {
        this(moduleRepository, Logger.getAnonymousLogger());
    }

    public PackageAnalyser(Repository repo, Logger logger) {
        this.moduleRepository = repo;
        this.logger = logger;
    }

    public void analyse(Bundle bundle) throws IOException {
        bundle.setRequiredBundles(this.computeRequiredBundles(bundle));
        bundle.setExportedPkgs(this.computeExportedPackages(bundle));
        bundle.setImportedPkgs(this.computeImportedPackages(bundle));
        bundle.setRequiredPkgs(this.computeRequiredPackages(bundle));
    }

    private Set<PackageRequirement> computeImportedPackages(Bundle bundle) {
        String importPkgHeader = bundle.getMd().getManifest().getMainAttributes().getValue("Import-Package");
        if (importPkgHeader == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<PackageRequirement> importedPkgs = new HashSet<PackageRequirement>();
        List<Token> tokens = this.tokenize(importPkgHeader);
        ArrayList<String> pkgNames = new ArrayList<String>();
        VersionRange versionRange = VersionRange.DEFAULT_VERSION_RANGE;
        boolean nextPkgGroup = false;
        block6: for (Token t : tokens) {
            switch (t.type) {
                case PKG: {
                    if (nextPkgGroup) {
                        for (String name : pkgNames) {
                            PackageRequirement pr = new PackageRequirement(name, versionRange);
                            importedPkgs.add(pr);
                        }
                        pkgNames.clear();
                        versionRange = VersionRange.DEFAULT_VERSION_RANGE;
                        nextPkgGroup = false;
                    }
                    pkgNames.add(t.value);
                    continue block6;
                }
                case DIRECTIVE: {
                    continue block6;
                }
                case ATTRIBUTE: {
                    int idx = t.value.indexOf(61);
                    assert (idx != -1);
                    String attrName = t.value.substring(0, idx);
                    if (!"version".equals(attrName)) continue block6;
                    String versionRangeStr = t.value.substring(idx + 1);
                    versionRange = VersionRange.valueOf(versionRangeStr);
                    continue block6;
                }
                case PKG_GROUP_SEP: {
                    nextPkgGroup = true;
                    continue block6;
                }
            }
            throw new RuntimeException("Unknown token type. Fix the program.");
        }
        if (!pkgNames.isEmpty()) {
            for (String name : pkgNames) {
                PackageRequirement pr = new PackageRequirement(name, versionRange);
                importedPkgs.add(pr);
            }
        }
        return importedPkgs;
    }

    private Set<String> computeRequiredPackages(Bundle bundle) throws IOException {
        HashSet<String> requiredPkgs = new HashSet<String>();
        File moduleFile = new File(bundle.getMd().getLocations()[0]);
        String classpath = moduleFile.getAbsolutePath();
        JarFile moduleJar = new JarFile(moduleFile);
        ClassFileLoader cfl = ClassFileLoaderFactory.newInstance(new Object[]{classpath});
        String classExt = ".class";
        Enumeration<JarEntry> entries = moduleJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            if (!je.getName().endsWith(".class")) continue;
            String className = Util.convertToExternalClassName(je.getName().substring(0, je.getName().length() - ".class".length()));
            ClassFile cf = null;
            try {
                cf = cfl.load(className);
                for (String c : cf.getAllReferencedClassNames()) {
                    requiredPkgs.add(Util.getPackageName(c));
                }
            }
            catch (IOException e) {
                this.logger.logp(Level.FINE, "PackageAnalyser", "computeRequiredPackages", "Skipping analysis of {0} as the following exception was thrown:\n {1}", new Object[]{className, e});
            }
        }
        return requiredPkgs;
    }

    private List<Token> tokenize(String header) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        StringBuilder token = new StringBuilder();
        Token.TYPE type = Token.TYPE.PKG;
        block7: for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            switch (c) {
                case '\"': {
                    int nextQuote = header.indexOf(34, i + 1);
                    token.append(header.substring(i, nextQuote + 1));
                    i = nextQuote;
                    continue block7;
                }
                case ':': {
                    token.append(c);
                    char c2 = header.charAt(i + 1);
                    if (c2 != '=') continue block7;
                    type = Token.TYPE.DIRECTIVE;
                    token.append(c2);
                    ++i;
                    continue block7;
                }
                case '=': {
                    type = Token.TYPE.ATTRIBUTE;
                    token.append(c);
                    continue block7;
                }
                case ',': {
                    tokens.add(Token.createToken(token.toString(), type));
                    tokens.add(Token.createToken(",", Token.TYPE.PKG_GROUP_SEP));
                    token.delete(0, token.length());
                    type = Token.TYPE.PKG;
                    continue block7;
                }
                case ';': {
                    tokens.add(Token.createToken(token.toString(), type));
                    token.delete(0, token.length());
                    type = Token.TYPE.PKG;
                    continue block7;
                }
                default: {
                    token.append(c);
                }
            }
        }
        if (token.length() > 0) {
            tokens.add(Token.createToken(token.toString(), type));
        }
        return tokens;
    }

    private List<PackageGroup> parseExportPackage(String header) {
        ArrayList<PackageGroup> pkgGroups = new ArrayList<PackageGroup>();
        List<Token> tokens = this.tokenize(header);
        ArrayList<String> pkgNames = new ArrayList<String>();
        ArrayList<String> pkgAttributes = new ArrayList<String>();
        ArrayList<String> pkgDirectives = new ArrayList<String>();
        boolean nextPkgGroup = false;
        block6: for (Token t : tokens) {
            switch (t.type) {
                case PKG: {
                    if (nextPkgGroup) {
                        pkgGroups.add(new PackageGroup(pkgNames, pkgAttributes, pkgDirectives));
                        pkgNames = new ArrayList();
                        pkgAttributes = new ArrayList();
                        pkgDirectives = new ArrayList();
                        nextPkgGroup = false;
                    }
                    pkgNames.add(t.value);
                    continue block6;
                }
                case ATTRIBUTE: {
                    pkgAttributes.add(t.value);
                    continue block6;
                }
                case DIRECTIVE: {
                    pkgDirectives.add(t.value);
                    continue block6;
                }
                case PKG_GROUP_SEP: {
                    nextPkgGroup = true;
                    continue block6;
                }
            }
            throw new RuntimeException("Unknown token type. Fix the program");
        }
        if (!pkgNames.isEmpty()) {
            pkgGroups.add(new PackageGroup(pkgNames, pkgAttributes, pkgDirectives));
        }
        return pkgGroups;
    }

    private Set<PackageCapability> computeExportedPackages(Bundle bundle) {
        HashSet<PackageCapability> exportedPkgs = new HashSet<PackageCapability>();
        String exportedPkgsAttr = bundle.getMd().getManifest().getMainAttributes().getValue("Export-Package");
        if (exportedPkgsAttr == null) {
            return exportedPkgs;
        }
        List<PackageGroup> pkgGroups = this.parseExportPackage(exportedPkgsAttr);
        for (PackageGroup pg : pkgGroups) {
            String version = null;
            for (String attr : pg.pkgAttributes) {
                int idx = attr.indexOf(61);
                assert (idx != -1);
                if (!"version".equals(attr.substring(0, idx)) || !(version = attr.substring(idx + 1)).startsWith("\"") || !version.endsWith("\"")) continue;
                version = version.substring(1, version.length() - 1);
            }
            for (String pkgName : pg.pkgNames) {
                PackageCapability p = new PackageCapability(pkgName, version);
                exportedPkgs.add(p);
            }
        }
        return exportedPkgs;
    }

    private Set<Bundle> computeRequiredBundles(Bundle bundle) {
        HashSet<Bundle> requiredBundles = new HashSet<Bundle>();
        for (ModuleDependency dep : bundle.getMd().getDependencies()) {
            ModuleDefinition md = this.moduleRepository.find(dep.getName(), dep.getVersion());
            if (md != null) {
                requiredBundles.add(new Bundle(md));
                continue;
            }
            System.out.println("WARNING: Missing dependency: [" + dep + "] for module [" + bundle.getName() + "]");
        }
        return requiredBundles;
    }

    public Collection<Wire> analyseWirings() throws IOException {
        List moduleDefs = this.moduleRepository.findAll();
        this.bundles = new HashSet<Bundle>();
        for (ModuleDefinition moduleDef : moduleDefs) {
            Bundle bundle = new Bundle(moduleDef);
            this.bundles.add(bundle);
            this.analyse(bundle);
        }
        HashSet<Wire> wires = new HashSet<Wire>();
        for (Bundle importer : this.bundles) {
            HashSet<String> importedPkgNames = new HashSet<String>();
            for (PackageRequirement pr : importer.getImportedPkgs()) {
                importedPkgNames.add(pr.getName());
                for (Bundle exporter : this.bundles) {
                    PackageCapability pc = exporter.provides(pr);
                    if (pc == null) continue;
                    Wire w = new Wire(pc, pr, importer, exporter);
                    wires.add(w);
                }
            }
            for (String pkg : importer.getRequiredPkgs()) {
                if (importedPkgNames.contains(pkg)) continue;
                for (Bundle exporter : this.bundles) {
                    if (!exporter.provides(pkg)) continue;
                    Wire w = new Wire(pkg, importer, exporter);
                    wires.add(w);
                }
            }
        }
        ArrayList<Wire> sorted = new ArrayList<Wire>(wires);
        Collections.sort(sorted, new Comparator<Wire>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(Wire o1, Wire o2) {
                return this.collator.compare(o1.pc.getName(), o2.pc.getName());
            }
        });
        return sorted;
    }

    public Collection<SplitPackage> findDuplicatePackages() {
        assert (this.bundles != null);
        HashMap<String, HashSet<Bundle>> packages = new HashMap<String, HashSet<Bundle>>();
        for (Bundle b : this.bundles) {
            for (PackageCapability p : b.getExportedPkgs()) {
                HashSet<Bundle> exporters = (HashSet<Bundle>)packages.get(p.getName());
                if (exporters == null) {
                    exporters = new HashSet<Bundle>();
                    packages.put(p.getName(), exporters);
                }
                exporters.add(b);
            }
        }
        HashSet<SplitPackage> duplicatePkgs = new HashSet<SplitPackage>();
        for (Map.Entry entry : packages.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            duplicatePkgs.add(new SplitPackage((String)entry.getKey(), (Set)entry.getValue()));
        }
        ArrayList<SplitPackage> sortedDuplicatePkgs = new ArrayList<SplitPackage>(duplicatePkgs);
        Collections.sort(sortedDuplicatePkgs, new Comparator<SplitPackage>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(SplitPackage o1, SplitPackage o2) {
                return this.collator.compare(o1.name, o2.name);
            }
        });
        return sortedDuplicatePkgs;
    }

    public Collection<PackageCapability> findAllExportedPackages() {
        ArrayList<PackageCapability> packages = new ArrayList<PackageCapability>();
        for (Bundle b : this.bundles) {
            packages.addAll(b.getExportedPkgs());
        }
        Collections.sort(packages);
        return packages;
    }

    public Collection<String> findAllExportedPackageNames() {
        Collection<PackageCapability> packages = this.findAllExportedPackages();
        HashSet<String> pkgNames = new HashSet<String>(packages.size());
        for (PackageCapability p : packages) {
            pkgNames.add(p.getName());
        }
        ArrayList<String> sorted = new ArrayList<String>(pkgNames);
        Collections.sort(sorted, new Comparator<String>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(String o1, String o2) {
                return this.collator.compare(o1, o2);
            }
        });
        return sorted;
    }

    public Set<Bundle> findAllBundles() {
        return this.bundles;
    }

    public Collection<PackageCapability> findUnusedExports() {
        ArrayList<PackageCapability> unusedPackages = new ArrayList<PackageCapability>();
        for (Bundle exporter : this.bundles) {
            unusedPackages.addAll(this.findUnusedExports(exporter));
        }
        Collections.sort(unusedPackages);
        return unusedPackages;
    }

    public Collection<PackageCapability> findUnusedExports(Bundle exporter) {
        ArrayList<PackageCapability> unusedPackages = new ArrayList<PackageCapability>();
        for (PackageCapability p : exporter.getExportedPkgs()) {
            boolean used = false;
            for (Bundle importer : this.bundles) {
                if (importer == exporter || !importer.requires(p)) continue;
                used = true;
                break;
            }
            if (used) continue;
            unusedPackages.add(p);
        }
        Collections.sort(unusedPackages);
        return unusedPackages;
    }

    public void generateWiringReport(Collection<PackageCapability> exportedPkgs, Collection<Wire> wires, PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<?xml-stylesheet type=\"text/xsl\" href=\"wires.xsl\"?>");
        out.println("<Wires>");
        for (PackageCapability p : exportedPkgs) {
            HashSet<String> exporters = new HashSet<String>();
            HashSet<String> importers = new HashSet<String>();
            for (Wire w : wires) {
                if (!w.getPc().equals(p)) continue;
                exporters.add(w.getExporter().getName());
                importers.add(w.getImporter().getName());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\t<Package name = \"" + p.getName() + "\" version = \"" + p.getVersion() + "\">\n");
            sb.append("\t\t<Exporters>\n");
            for (String e : exporters) {
                sb.append(e + " ");
            }
            sb.append("\n\t\t</Exporters>\n");
            sb.append("\t\t<Importers>\n");
            for (String e : importers) {
                sb.append(e + " ");
            }
            sb.append("\n\t\t</Importers>\n");
            sb.append("\t</Package>");
            out.println(sb);
        }
        out.println("</Wires>");
    }

    public void generateBundleReport(PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<Bundles>");
        for (Bundle b : this.bundles) {
            StringBuilder sb = new StringBuilder();
            Set<PackageCapability> allpcs = b.getExportedPkgs();
            Collection<PackageCapability> unusedpcs = this.findUnusedExports(b);
            HashSet<PackageCapability> usedpcs = new HashSet<PackageCapability>(allpcs);
            usedpcs.removeAll(unusedpcs);
            sb.append("\t<Bundle name=\"" + b.getName() + "\" file=\"" + this.getBundleLocation(b) + "\" " + " total-exports=\"" + allpcs.size() + "\" used=\"" + usedpcs.size() + "\" unused=\"" + unusedpcs.size() + "\" " + "total-imports=\"" + b.getImportedPkgs().size() + "\">\n");
            sb.append("\t\t<Exports>\n");
            sb.append("\t\t\t<Used>\n");
            int i = 0;
            for (PackageCapability pc : usedpcs) {
                sb.append("\t\t\t\t" + pc);
                if (++i < usedpcs.size()) {
                    sb.append(",\\");
                }
                sb.append("\n");
            }
            sb.append("\t\t\t</Used>\n");
            sb.append("\t\t\t<Unused>\n");
            i = 0;
            for (PackageCapability pc : unusedpcs) {
                sb.append("\t\t\t\t" + pc);
                if (++i < unusedpcs.size()) {
                    sb.append(",\\");
                }
                sb.append("\n");
            }
            sb.append("\t\t\t</Unused>\n");
            sb.append("\t\t</Exports>\n");
            sb.append("\t\t<Imports>\n");
            ArrayList<PackageRequirement> prs = new ArrayList<PackageRequirement>(b.getImportedPkgs());
            Collections.sort(prs);
            i = 0;
            for (PackageRequirement pr : prs) {
                sb.append("\t\t\t" + pr);
                if (++i < prs.size()) {
                    sb.append(",\\");
                }
                sb.append("\n");
            }
            sb.append("\t\t</Imports>\n");
            sb.append("\t</Bundle>");
            out.println(sb);
        }
        out.println("</Bundles>");
    }

    private String getBundleLocation(Bundle b) {
        return new File(b.getMd().getLocations()[0]).getName();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("Usage: java " + PackageAnalyser.class.getName() + " <Repository Dir Path> <output file name for bundle details>" + " <output file name for wiring details> <output file name for duplicate-packages> <output file name for unused packages>");
            System.out.println("Example(s):\nFollowing command analyses all modules in the specified repository:\n java " + PackageAnalyser.class.getName() + " /tmp/glassfish/modules/ bundles.xml wires.xml duplicate.txt unused.xml\n\n");
            return;
        }
        String repoPath = args[0];
        PrintStream bundleOut = new PrintStream(new FileOutputStream(args[1]));
        PrintStream wireOut = new PrintStream(new FileOutputStream(args[2]));
        PrintStream spOut = new PrintStream(new FileOutputStream(args[3]));
        PrintStream unusedPkgOut = new PrintStream(new FileOutputStream(args[4]));
        File f = new File(repoPath){

            @Override
            public File[] listFiles() {
                ArrayList<File> files = new ArrayList<File>();
                for (File f : super.listFiles()) {
                    if (f.isDirectory()) {
                        for (File f2 : f.listFiles()) {
                            if (!f2.isFile() || !f2.getName().endsWith(".jar")) continue;
                            files.add(f2);
                        }
                        continue;
                    }
                    if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                    files.add(f);
                }
                return files.toArray(new File[files.size()]);
            }
        };
        if (!f.exists()) {
            System.err.println(repoPath + " does not exist.");
            System.exit(-1);
        }
        OSGiFactoryImpl.initialize(null);
        OSGiDirectoryBasedRepository moduleRepository = new OSGiDirectoryBasedRepository("repo", f);
        moduleRepository.initialize();
        PackageAnalyser analyser = new PackageAnalyser((Repository)moduleRepository);
        Collection<Wire> wires = analyser.analyseWirings();
        Collection<PackageCapability> exportedPkgs = analyser.findAllExportedPackages();
        analyser.generateBundleReport(bundleOut);
        analyser.generateWiringReport(exportedPkgs, wires, wireOut);
        Collection<SplitPackage> splitPkgs = analyser.findDuplicatePackages();
        for (SplitPackage p : splitPkgs) {
            spOut.println(p + "\n");
        }
        spOut.println("Total number of Duplicate Packages = " + splitPkgs.size());
        int totalUnusedPkgs = 0;
        for (Bundle b : analyser.bundles) {
            Collection<PackageCapability> unusedPackages = analyser.findUnusedExports(b);
            if (!unusedPackages.isEmpty()) {
                unusedPkgOut.println("<Bundle name=" + b.getName() + ", totalUnusedPkgs = " + unusedPackages.size() + "> \n");
                for (PackageCapability p : unusedPackages) {
                    unusedPkgOut.println("\t" + p + "\n");
                }
                unusedPkgOut.println("</Bundle>\n");
            }
            totalUnusedPkgs += unusedPackages.size();
        }
        unusedPkgOut.println("Total number of Unused Packages = " + totalUnusedPkgs);
        System.out.println("******** GROSS STATISTICS *********");
        System.out.println("Total number of bundles in this repository: " + analyser.findAllBundles().size());
        System.out.println("Total number of wires = " + wires.size());
        System.out.println("Total number of exported packages = " + exportedPkgs.size());
        System.out.println("Total number of duplicate-packages = " + splitPkgs.size());
        System.out.println("Total number of unused-packages = " + totalUnusedPkgs);
    }

    private static class PackageGroup {
        final List<String> pkgNames;
        final List<String> pkgAttributes;
        final List<String> pkgDirectives;

        private PackageGroup(List<String> pkgNames, List<String> pkgAttributes, List<String> pkgDirectives) {
            this.pkgNames = pkgNames;
            this.pkgAttributes = pkgAttributes;
            this.pkgDirectives = pkgDirectives;
        }
    }

    static class Token {
        final String value;
        final TYPE type;

        private Token(String value, TYPE type) {
            this.value = value;
            this.type = type;
        }

        public static Token createToken(String s, TYPE type) {
            return new Token(s, type);
        }

        static enum TYPE {
            PKG,
            ATTRIBUTE,
            DIRECTIVE,
            PKG_GROUP_SEP;

        }
    }

    public static class SplitPackage {
        String name;
        Set<Bundle> exporters = new HashSet<Bundle>();

        public SplitPackage(String name, Set<Bundle> exporters) {
            this.name = name;
            this.exporters = exporters;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SplitPackage) {
                return this.name.equals(SplitPackage.class.cast(obj));
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("name " + this.name + " (" + this.exporters.size() + " times):\n");
            for (Bundle b : this.exporters) {
                sb.append(b.getMd().getName() + "\n");
            }
            return sb.toString();
        }
    }

    public static class Wire {
        PackageCapability pc;
        Bundle exporter;
        PackageRequirement pr;
        Bundle importer;

        public Wire(String pkg, Bundle importer, Bundle exporter) {
            this(new PackageCapability(pkg), new PackageRequirement(pkg, VersionRange.DEFAULT_VERSION_RANGE), importer, exporter);
        }

        public Wire(PackageCapability pc, PackageRequirement pr, Bundle importer, Bundle exporter) {
            this.exporter = exporter;
            this.importer = importer;
            this.pc = pc;
            this.pr = pr;
            assert (pc.getName().equals(pr.getName()));
        }

        public PackageCapability getPc() {
            return this.pc;
        }

        public PackageRequirement getPr() {
            return this.pr;
        }

        public String getPkg() {
            return this.pc.getName();
        }

        public Bundle getExporter() {
            return this.exporter;
        }

        public Bundle getImporter() {
            return this.importer;
        }

        public int hashCode() {
            return this.getPkg().hashCode();
        }

        public boolean equals(Object obj) {
            boolean b = false;
            if (obj instanceof Wire) {
                Wire other = (Wire)Wire.class.cast(obj);
                boolean bl = b = this.pc.equals(other.pc) && this.pr.equals(other.pr);
                if (b) {
                    if (this.exporter != null) {
                        b = this.exporter.equals(other.exporter);
                    } else {
                        boolean bl2 = b = other.exporter == null;
                    }
                    if (b) {
                        b = this.importer != null ? this.importer.equals(other.importer) : other.importer == null;
                    }
                }
            }
            return b;
        }

        public String toString() {
            return "Wire [Package = " + this.pc + ", Importer = " + this.importer.getMd().getName() + ", Exporter = " + this.exporter.getMd().getName() + "]";
        }
    }

    public static class Bundle {
        private ModuleDefinition md;
        private Set<PackageCapability> exportedPkgs = new HashSet<PackageCapability>();
        private Set<String> exportedPkgNames = new HashSet<String>();
        private Set<String> requiredPkgs = new HashSet<String>();
        private Set<PackageRequirement> importedPkgs = new HashSet<PackageRequirement>();
        private Set<Bundle> requiredBundles = new HashSet<Bundle>();

        Bundle(ModuleDefinition md) {
            this.setMd(md);
        }

        public Set<PackageCapability> getExportedPkgs() {
            return Collections.unmodifiableSet(this.exportedPkgs);
        }

        public void setExportedPkgs(Set<PackageCapability> exportedPkgs) {
            this.exportedPkgs = exportedPkgs;
            for (PackageCapability p : exportedPkgs) {
                this.exportedPkgNames.add(p.getName());
            }
        }

        public Set<PackageRequirement> getImportedPkgs() {
            return Collections.unmodifiableSet(this.importedPkgs);
        }

        public void setImportedPkgs(Set<PackageRequirement> importedPkgs) {
            this.importedPkgs = importedPkgs;
        }

        public Set<String> getRequiredPkgs() {
            return Collections.unmodifiableSet(this.requiredPkgs);
        }

        public void setRequiredPkgs(Set<String> requiredPkgs) {
            this.requiredPkgs = requiredPkgs;
        }

        public Set<Bundle> getRequiredBundles() {
            return Collections.unmodifiableSet(this.requiredBundles);
        }

        public void setRequiredBundles(Set<Bundle> requiredBundles) {
            this.requiredBundles = requiredBundles;
        }

        public ModuleDefinition getMd() {
            return this.md;
        }

        public boolean provides(String pkg) {
            return this.exportedPkgNames.contains(pkg);
        }

        public PackageCapability provides(PackageRequirement pr) {
            if (this.provides(pr.getName())) {
                for (PackageCapability pc : this.getExportedPkgs()) {
                    if (!pc.getName().equals(pr.getName()) || !pr.getVersionRange().isInRange(pc.getVersion())) continue;
                    return pc;
                }
            }
            return null;
        }

        public boolean requires(PackageCapability p) {
            return this.getRequiredPkgs().contains(p.getName());
        }

        public int hashCode() {
            return this.getMd().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bundle) {
                return this.getMd().equals(((Bundle)Bundle.class.cast(obj)).getMd());
            }
            return false;
        }

        public String getName() {
            return this.getMd().getName();
        }

        public void setMd(ModuleDefinition md) {
            this.md = md;
        }
    }

    private static class PackageRequirement
    implements Comparable<PackageRequirement> {
        private String name;
        private VersionRange versionRange;

        private PackageRequirement(String name, VersionRange versionRange) {
            this.name = name;
            this.versionRange = versionRange;
            assert (versionRange != null);
        }

        public String getName() {
            return this.name;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        @Override
        public int compareTo(PackageRequirement o) {
            Collator collator = Collator.getInstance();
            int i = collator.compare(this.getName(), o.getName());
            if (i == 0) {
                i = this.getVersionRange().toString().compareTo(o.getVersionRange().toString());
            }
            return i;
        }

        public String toString() {
            return this.name + "; version=" + this.versionRange;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            boolean b = obj instanceof PackageRequirement;
            if (b) {
                PackageRequirement other = (PackageRequirement)obj;
                b = this.name.equals(other.name) && this.versionRange.equals(other.versionRange);
            }
            return b;
        }
    }

    public static class PackageCapability
    implements Comparable<PackageCapability> {
        private String name;
        private Version version = Version.emptyVersion;

        public PackageCapability(String name, String versionStr) {
            this.name = name.trim();
            if (versionStr != null && versionStr.trim().length() > 0) {
                this.version = new Version(versionStr.trim());
            }
        }

        public PackageCapability(String name) {
            this(name, null);
        }

        public String toString() {
            return this.name + "; version=" + this.version;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(PackageCapability o) {
            Collator collator = Collator.getInstance();
            int i = collator.compare(this.getName(), o.getName());
            if (i == 0) {
                i = this.getVersion().compareTo((Object)o.getVersion());
            }
            return i;
        }

        public int hashCode() {
            return this.name.hashCode() + this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PackageCapability) {
                PackageCapability other = (PackageCapability)PackageCapability.class.cast(obj);
                return this.name.equals(other.name) && this.version.equals((Object)other.version);
            }
            return false;
        }
    }

    private static class VersionRange {
        private final Version lowerVersion;
        private final boolean lowerVersionInclussive;
        private final Version upperVersion;
        private final boolean upperVersionInclussive;
        private static final VersionRange DEFAULT_VERSION_RANGE = new VersionRange();
        private static final String LSB = "[";
        private static final String LP = "(";
        private static final String RSB = "]";

        public VersionRange(Version lowerVersion, boolean lowerVersionInclussive, Version upperVersion, boolean upperVersionInclussive) {
            this.lowerVersion = lowerVersion;
            this.lowerVersionInclussive = lowerVersionInclussive;
            this.upperVersion = upperVersion;
            this.upperVersionInclussive = upperVersionInclussive;
        }

        private VersionRange(Version lowerVersion) {
            this(lowerVersion, true, null, false);
        }

        public VersionRange() {
            this(Version.emptyVersion, true, null, false);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            boolean b = obj instanceof VersionRange;
            if (b) {
                VersionRange other = (VersionRange)obj;
                boolean bl = b = this.lowerVersion.equals((Object)other.lowerVersion) && this.lowerVersionInclussive == other.lowerVersionInclussive;
                if (b) {
                    boolean bl2 = b = this.upperVersionInclussive == other.upperVersionInclussive;
                    if (b) {
                        b = this.upperVersion != null && this.upperVersion.equals((Object)other.upperVersion) || other.upperVersion == null;
                    }
                }
                return b;
            }
            return b;
        }

        public static VersionRange valueOf(String s) {
            if (s == null) {
                s = "";
            }
            if (s.startsWith("\"")) {
                assert (s.endsWith("\""));
                s = s.substring(1, s.length() - 1);
            }
            if (s.length() == 0) {
                return DEFAULT_VERSION_RANGE;
            }
            if (s.startsWith(LP) || s.startsWith(LSB)) {
                int comma = s.indexOf(44, 1);
                String lvs = s.substring(1, comma).trim();
                Version lv = new Version(lvs);
                String uvs = s.substring(comma + 1, s.length() - 1).trim();
                Version uv = new Version(uvs);
                boolean lowerVersionInclussive = s.startsWith(LSB);
                boolean upperVersionInclussive = s.endsWith(RSB);
                return new VersionRange(lv, lowerVersionInclussive, uv, upperVersionInclussive);
            }
            Version lv = new Version(s.trim());
            return new VersionRange(lv);
        }

        public boolean isInRange(Version version) {
            boolean lowerVersionMatches;
            int distanceFromLowerVersion = version.compareTo((Object)this.lowerVersion);
            boolean bl = this.lowerVersionInclussive ? distanceFromLowerVersion >= 0 : (lowerVersionMatches = distanceFromLowerVersion > 0);
            if (lowerVersionMatches) {
                if (this.upperVersion != null) {
                    int distanceFromUpperVersion = version.compareTo((Object)this.upperVersion);
                    boolean upperVersionMatches = this.upperVersionInclussive ? distanceFromUpperVersion <= 0 : distanceFromUpperVersion < 0;
                    return upperVersionMatches;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("\"");
            sb.append(this.lowerVersionInclussive ? LSB : LP).append(this.lowerVersion).append(", ");
            sb.append(this.upperVersion != null ? this.upperVersion.toString() : "infinity").append(this.upperVersionInclussive ? RSB : ")");
            sb.append("\"");
            return sb.toString();
        }
    }
}

