/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerThread;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.internal.JaxRsClassAnalyzer;
import org.glassfish.hk2.internal.PerThreadContext;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;

public abstract class ServiceLocatorUtilities {
    private static final String DEFAULT_LOCATOR_NAME = "default";
    public static final String PREFER_LARGEST_CONSTRUCTOR = "PreferLargestConstructor";

    public static void enablePerThreadScope(ServiceLocator locator) {
        Context perThreadContext = (Context)locator.getService(new TypeLiteral<Context<PerThread>>(){}.getType(), new Annotation[0]);
        if (perThreadContext != null) {
            return;
        }
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        DescriptorImpl descriptor = BuilderHelper.link(PerThreadContext.class).to(Context.class).in(Singleton.class.getName()).build();
        ClassLoader loader = ServiceLocatorUtilities.class.getClassLoader();
        final ClassLoader binderClassLoader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        descriptor.setLoader(new HK2Loader(){

            @Override
            public Class<?> loadClass(String className) throws MultiException {
                try {
                    return binderClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new MultiException(e);
                }
            }
        });
        config.bind(descriptor);
        config.commit();
    }

    public static void bind(ServiceLocator locator, Binder ... binders) {
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        for (Binder binder : binders) {
            binder.bind(config);
        }
        config.commit();
    }

    public static ServiceLocator bind(String name, Binder ... binders) {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        ServiceLocator locator = factory.create(name);
        ServiceLocatorUtilities.bind(locator, binders);
        return locator;
    }

    public static ServiceLocator bind(Binder ... binders) {
        return ServiceLocatorUtilities.bind(DEFAULT_LOCATOR_NAME, binders);
    }

    public static <T> ActiveDescriptor<T> addOneConstant(ServiceLocator locator, Object constant) {
        if (locator == null || constant == null) {
            throw new IllegalArgumentException();
        }
        return ServiceLocatorUtilities.addOneDescriptor(locator, BuilderHelper.createConstantDescriptor(constant));
    }

    public static <T> ActiveDescriptor<T> addOneConstant(ServiceLocator locator, Object constant, String name, Type ... contracts) {
        if (locator == null || constant == null) {
            throw new IllegalArgumentException();
        }
        return ServiceLocatorUtilities.addOneDescriptor(locator, BuilderHelper.createConstantDescriptor(constant, name, contracts));
    }

    public static <T> ActiveDescriptor<T> addOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        ActiveDescriptor active;
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        ActiveDescriptor retVal = descriptor instanceof ActiveDescriptor ? ((active = (ActiveDescriptor)descriptor).isReified() ? config.addActiveDescriptor(active) : config.bind(descriptor)) : config.bind(descriptor);
        config.commit();
        return retVal;
    }

    public static <T> ActiveDescriptor<T> findOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        ActiveDescriptor<?> retVal;
        if (locator == null || descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (descriptor.getServiceId() != null && descriptor.getLocatorId() != null && (retVal = locator.getBestDescriptor(BuilderHelper.createSpecificDescriptorFilter(descriptor))) != null) {
            return retVal;
        }
        final DescriptorImpl di = descriptor instanceof DescriptorImpl ? (DescriptorImpl)descriptor : new DescriptorImpl(descriptor);
        ActiveDescriptor<?> retVal2 = locator.getBestDescriptor(new Filter(){

            @Override
            public boolean matches(Descriptor d) {
                return di.equals(d);
            }
        });
        return retVal2;
    }

    public static void removeOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        if (locator == null || descriptor == null) {
            throw new IllegalArgumentException();
        }
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        if (descriptor.getLocatorId() != null && descriptor.getServiceId() != null) {
            IndexedFilter destructionFilter = BuilderHelper.createSpecificDescriptorFilter(descriptor);
            config.addUnbindFilter(destructionFilter);
            config.commit();
            return;
        }
        final DescriptorImpl di = descriptor instanceof DescriptorImpl ? (DescriptorImpl)descriptor : new DescriptorImpl(descriptor);
        Filter destructionFilter = new Filter(){

            @Override
            public boolean matches(Descriptor d) {
                return di.equals(d);
            }
        };
        config.addUnbindFilter(destructionFilter);
        config.commit();
    }

    public static void removeFilter(ServiceLocator locator, Filter filter) {
        if (locator == null || filter == null) {
            throw new IllegalArgumentException();
        }
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter(filter);
        config.commit();
    }

    public static <T> T getService(ServiceLocator locator, String className) {
        if (locator == null || className == null) {
            throw new IllegalArgumentException();
        }
        ActiveDescriptor<?> ad = locator.getBestDescriptor(BuilderHelper.createContractFilter(className));
        if (ad == null) {
            return null;
        }
        return (T)locator.getServiceHandle(ad).getService();
    }

    public static <T> T getService(ServiceLocator locator, Descriptor descriptor) {
        if (locator == null || descriptor == null) {
            throw new IllegalArgumentException();
        }
        Long locatorId = descriptor.getLocatorId();
        if (locatorId != null && locatorId.longValue() == locator.getLocatorId() && descriptor instanceof ActiveDescriptor) {
            return locator.getServiceHandle((ActiveDescriptor)descriptor).getService();
        }
        ActiveDescriptor<T> found = ServiceLocatorUtilities.findOneDescriptor(locator, descriptor);
        if (found == null) {
            return null;
        }
        return locator.getServiceHandle(found).getService();
    }

    public static DynamicConfiguration createDynamicConfiguration(ServiceLocator locator) throws IllegalStateException {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        DynamicConfigurationService dcs = locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        if (dcs == null) {
            throw new IllegalStateException();
        }
        return dcs.createDynamicConfiguration();
    }

    public static <T> T findOrCreateService(ServiceLocator locator, Class<T> type, Annotation ... qualifiers) throws MultiException {
        if (locator == null || type == null) {
            throw new IllegalArgumentException();
        }
        ServiceHandle<T> retVal = locator.getServiceHandle(type, qualifiers);
        if (retVal == null) {
            return locator.createAndInitialize(type);
        }
        return retVal.getService();
    }

    public static String getOneMetadataField(Descriptor d, String field) {
        Map<String, List<String>> metadata = d.getMetadata();
        List<String> values = metadata.get(field);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public static String getOneMetadataField(ServiceHandle<?> h, String field) {
        return ServiceLocatorUtilities.getOneMetadataField(h.getActiveDescriptor(), field);
    }

    public static void addPreferLargestConstructorClassAnalyzer(ServiceLocator locator) {
        ClassAnalyzer ca = locator.getService(ClassAnalyzer.class, PREFER_LARGEST_CONSTRUCTOR, new Annotation[0]);
        if (ca != null) {
            return;
        }
        DescriptorImpl d = BuilderHelper.link(JaxRsClassAnalyzer.class).to(ClassAnalyzer.class.getName()).in(Singleton.class.getName()).named(PREFER_LARGEST_CONSTRUCTOR).build();
        ServiceLocatorUtilities.addOneDescriptor(locator, d);
    }
}

