/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.reflection.Logger;

@Singleton
@Named(value="PreferLargestConstructor")
public class JaxRsClassAnalyzer
implements ClassAnalyzer {
    @Inject
    @Named(value="default")
    private ClassAnalyzer defaultAnalyzer;

    @Override
    public <T> Constructor<T> getConstructor(Class<T> clazz) throws MultiException, NoSuchMethodException {
        Constructor<Inject> retVal = null;
        try {
            retVal = this.defaultAnalyzer.getConstructor(clazz);
            Class<?>[] args = retVal.getParameterTypes();
            if (args.length != 0) {
                return retVal;
            }
            Inject i = retVal.getAnnotation(Inject.class);
            if (i != null) {
                return retVal;
            }
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        Constructor<?>[] allCs = clazz.getDeclaredConstructors();
        LinkedList allMaximums = new LinkedList();
        int currentBestSize = -1;
        for (Constructor<?> candidate : allCs) {
            Class<?>[] params = candidate.getParameterTypes();
            if (params.length > currentBestSize) {
                currentBestSize = params.length;
                allMaximums.clear();
                allMaximums.add(candidate);
                continue;
            }
            if (params.length != currentBestSize) continue;
            allMaximums.add(candidate);
        }
        if (allMaximums.size() > 1) {
            Logger.getLogger().warning("There were " + allMaximums.size() + " constructors with " + currentBestSize + " parameters on class " + clazz.getName() + ", making choice of the proper constructor ambiguous.  A random constructor shall be chosen");
        }
        if (allMaximums.isEmpty()) {
            throw new NoSuchMethodException("Could not find any constructors on " + clazz.getName());
        }
        return (Constructor)allMaximums.get(0);
    }

    @Override
    public <T> Set<Method> getInitializerMethods(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getInitializerMethods(clazz);
    }

    @Override
    public <T> Set<Field> getFields(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getFields(clazz);
    }

    @Override
    public <T> Method getPostConstructMethod(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getPostConstructMethod(clazz);
    }

    @Override
    public <T> Method getPreDestroyMethod(Class<T> clazz) throws MultiException {
        return this.defaultAnalyzer.getPreDestroyMethod(clazz);
    }
}

