/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;

public class DescriptorImpl
implements Descriptor,
Serializable {
    private static final long serialVersionUID = 1558442492395467828L;
    private static final String CONTRACT_KEY = "contract=";
    private static final String NAME_KEY = "name=";
    private static final String SCOPE_KEY = "scope=";
    private static final String QUALIFIER_KEY = "qualifier=";
    private static final String TYPE_KEY = "type=";
    private static final String VISIBILITY_KEY = "visibility=";
    private static final String METADATA_KEY = "metadata=";
    private static final String RANKING_KEY = "rank=";
    private static final String PROXIABLE_KEY = "proxiable=";
    private static final String FACTORY_DT = "FACTORY";
    private static final String LOCAL_DT = "LOCAL";
    private static final String START_START = "[";
    private static final String END_START = "]";
    private static final char END_START_CHAR = ']';
    private Set<String> contracts = new LinkedHashSet<String>();
    private String implementation;
    private String name;
    private String scope = PerLookup.class.getName();
    private final Map<String, List<String>> metadatas = new LinkedHashMap<String, List<String>>();
    private Set<String> qualifiers = new LinkedHashSet<String>();
    private DescriptorType descriptorType = DescriptorType.CLASS;
    private DescriptorVisibility descriptorVisibility = DescriptorVisibility.NORMAL;
    private transient HK2Loader loader;
    private int rank;
    private Boolean proxiable;
    private Descriptor baseDescriptor;
    private Long id;
    private Long locatorId;

    public DescriptorImpl() {
    }

    public DescriptorImpl(Descriptor copyMe) {
        this.name = copyMe.getName();
        this.scope = copyMe.getScope();
        this.implementation = copyMe.getImplementation();
        this.descriptorType = copyMe.getDescriptorType();
        this.descriptorVisibility = copyMe.getDescriptorVisibility();
        this.loader = copyMe.getLoader();
        this.rank = copyMe.getRanking();
        this.proxiable = copyMe.isProxiable();
        this.id = copyMe.getServiceId();
        this.locatorId = copyMe.getLocatorId();
        this.baseDescriptor = copyMe.getBaseDescriptor();
        if (copyMe.getAdvertisedContracts() != null) {
            this.contracts.addAll(copyMe.getAdvertisedContracts());
        }
        if (copyMe.getQualifiers() != null) {
            this.qualifiers.addAll(copyMe.getQualifiers());
        }
        if (copyMe.getMetadata() != null) {
            this.metadatas.putAll(ReflectionHelper.deepCopyMetadata(copyMe.getMetadata()));
        }
    }

    public DescriptorImpl(Set<String> contracts, String name, String scope, String implementation, Map<String, List<String>> metadatas, Set<String> qualifiers, DescriptorType descriptorType, DescriptorVisibility descriptorVisibility, HK2Loader loader, int rank, Boolean proxiable, Descriptor baseDescriptor, Long id, Long locatorId) {
        this.contracts.addAll(contracts);
        this.implementation = implementation;
        this.name = name;
        this.scope = scope;
        this.metadatas.putAll(ReflectionHelper.deepCopyMetadata(metadatas));
        this.qualifiers.addAll(qualifiers);
        this.descriptorType = descriptorType;
        this.descriptorVisibility = descriptorVisibility;
        this.id = id;
        this.rank = rank;
        this.proxiable = proxiable;
        this.locatorId = locatorId;
        this.loader = loader;
        this.baseDescriptor = baseDescriptor;
    }

    @Override
    public synchronized Set<String> getAdvertisedContracts() {
        return Collections.unmodifiableSet(this.contracts);
    }

    public synchronized void addAdvertisedContract(String addMe) {
        if (addMe == null) {
            return;
        }
        this.contracts.add(addMe);
    }

    public synchronized boolean removeAdvertisedContract(String removeMe) {
        if (removeMe == null) {
            return false;
        }
        return this.contracts.remove(removeMe);
    }

    @Override
    public synchronized String getImplementation() {
        return this.implementation;
    }

    public synchronized void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    @Override
    public synchronized String getScope() {
        return this.scope;
    }

    public synchronized void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized Set<String> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public synchronized void addQualifier(String addMe) {
        if (addMe == null) {
            return;
        }
        this.qualifiers.add(addMe);
    }

    public synchronized boolean removeQualifier(String removeMe) {
        if (removeMe == null) {
            return false;
        }
        return this.qualifiers.remove(removeMe);
    }

    @Override
    public synchronized DescriptorType getDescriptorType() {
        return this.descriptorType;
    }

    public synchronized void setDescriptorType(DescriptorType descriptorType) {
        if (descriptorType == null) {
            throw new IllegalArgumentException();
        }
        this.descriptorType = descriptorType;
    }

    @Override
    public synchronized DescriptorVisibility getDescriptorVisibility() {
        return this.descriptorVisibility;
    }

    public synchronized void setDescriptorVisibility(DescriptorVisibility descriptorVisibility) {
        if (descriptorVisibility == null) {
            throw new IllegalArgumentException();
        }
        this.descriptorVisibility = descriptorVisibility;
    }

    @Override
    public synchronized Map<String, List<String>> getMetadata() {
        return Collections.unmodifiableMap(this.metadatas);
    }

    public synchronized void setMetadata(Map<String, List<String>> metadata) {
        this.metadatas.clear();
        this.metadatas.putAll(ReflectionHelper.deepCopyMetadata(metadata));
    }

    public synchronized void addMetadata(String key, String value) {
        ReflectionHelper.addMetadata(this.metadatas, (String)key, (String)value);
    }

    public synchronized boolean removeMetadata(String key, String value) {
        return ReflectionHelper.removeMetadata(this.metadatas, (String)key, (String)value);
    }

    public synchronized boolean removeAllMetadata(String key) {
        return ReflectionHelper.removeAllMetadata(this.metadatas, (String)key);
    }

    public synchronized void clearMetadata() {
        this.metadatas.clear();
    }

    @Override
    public synchronized HK2Loader getLoader() {
        return this.loader;
    }

    public synchronized void setLoader(HK2Loader loader) {
        this.loader = loader;
    }

    @Override
    public synchronized int getRanking() {
        return this.rank;
    }

    @Override
    public synchronized int setRanking(int ranking) {
        int retVal = this.rank;
        this.rank = ranking;
        return retVal;
    }

    @Override
    public synchronized Descriptor getBaseDescriptor() {
        return this.baseDescriptor;
    }

    public synchronized void setBaseDescriptor(Descriptor baseDescriptor) {
        this.baseDescriptor = baseDescriptor;
    }

    @Override
    public synchronized Long getServiceId() {
        return this.id;
    }

    public synchronized void setServiceId(Long id) {
        this.id = id;
    }

    @Override
    public Boolean isProxiable() {
        return this.proxiable;
    }

    public void setProxiable(Boolean proxiable) {
        this.proxiable = proxiable;
    }

    @Override
    public synchronized Long getLocatorId() {
        return this.locatorId;
    }

    public synchronized void setLocatorId(Long locatorId) {
        this.locatorId = locatorId;
    }

    public int hashCode() {
        int retVal = 0;
        if (this.implementation != null) {
            retVal ^= this.implementation.hashCode();
        }
        if (this.contracts != null) {
            for (String string : this.contracts) {
                retVal ^= string.hashCode();
            }
        }
        if (this.name != null) {
            retVal ^= this.name.hashCode();
        }
        if (this.scope != null) {
            retVal ^= this.scope.hashCode();
        }
        if (this.qualifiers != null) {
            for (String string : this.qualifiers) {
                retVal ^= string.hashCode();
            }
        }
        if (this.descriptorType != null) {
            retVal ^= this.descriptorType.hashCode();
        }
        if (this.descriptorVisibility != null) {
            retVal ^= this.descriptorVisibility.hashCode();
        }
        if (this.metadatas != null) {
            for (Map.Entry entry : this.metadatas.entrySet()) {
                retVal ^= ((String)entry.getKey()).hashCode();
                for (String value : (List)entry.getValue()) {
                    retVal ^= value.hashCode();
                }
            }
        }
        if (this.proxiable != null) {
            retVal = this.proxiable.booleanValue() ? (retVal ^= 1) : (retVal ^= 0xFFFFFFFF);
        }
        return retVal;
    }

    private static boolean safeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static <T> boolean equalOrderedCollection(Collection<T> a, Collection<T> b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Object[] aAsArray = a.toArray();
        Object[] bAsArray = b.toArray();
        for (int lcv = 0; lcv < a.size(); ++lcv) {
            if (DescriptorImpl.safeEquals(aAsArray[lcv], bAsArray[lcv])) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean equalMetadata(Map<String, List<String>> a, Map<String, List<String>> b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : a.entrySet()) {
            String aKey = entry.getKey();
            List<String> aValue = entry.getValue();
            List<String> bValue = b.get(aKey);
            if (bValue == null) {
                return false;
            }
            if (DescriptorImpl.equalOrderedCollection(aValue, bValue)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object a) {
        if (a == null) {
            return false;
        }
        if (!(a instanceof Descriptor)) {
            return false;
        }
        Descriptor d = (Descriptor)a;
        if (!DescriptorImpl.safeEquals(this.implementation, d.getImplementation())) {
            return false;
        }
        if (!DescriptorImpl.equalOrderedCollection(this.contracts, d.getAdvertisedContracts())) {
            return false;
        }
        if (!DescriptorImpl.safeEquals(this.name, d.getName())) {
            return false;
        }
        if (!DescriptorImpl.safeEquals(this.scope, d.getScope())) {
            return false;
        }
        if (!DescriptorImpl.equalOrderedCollection(this.qualifiers, d.getQualifiers())) {
            return false;
        }
        if (!DescriptorImpl.safeEquals((Object)this.descriptorType, (Object)d.getDescriptorType())) {
            return false;
        }
        if (!DescriptorImpl.safeEquals((Object)this.descriptorVisibility, (Object)d.getDescriptorVisibility())) {
            return false;
        }
        if (!DescriptorImpl.equalMetadata(this.metadatas, d.getMetadata())) {
            return false;
        }
        return DescriptorImpl.safeEquals(this.proxiable, d.isProxiable());
    }

    public static void pretty(StringBuffer sb, Descriptor d) {
        if (sb == null || d == null) {
            return;
        }
        sb.append("\n\timplementation=" + d.getImplementation());
        if (d.getName() != null) {
            sb.append("\n\tname=" + d.getName());
        }
        sb.append("\n\tcontracts=");
        sb.append(ReflectionHelper.writeSet(d.getAdvertisedContracts()));
        sb.append("\n\tscope=" + d.getScope());
        sb.append("\n\tqualifiers=");
        sb.append(ReflectionHelper.writeSet(d.getQualifiers()));
        sb.append("\n\tdescriptorType=" + (Object)((Object)d.getDescriptorType()));
        sb.append("\n\tdescriptorVisibility=" + (Object)((Object)d.getDescriptorVisibility()));
        sb.append("\n\tmetadata=");
        sb.append(ReflectionHelper.writeMetadata(d.getMetadata()));
        sb.append("\n\trank=" + d.getRanking());
        sb.append("\n\tloader=" + d.getLoader());
        sb.append("\n\tproxiable=" + d.isProxiable());
        sb.append("\n\tid=" + d.getServiceId());
        sb.append("\n\tlocatorId=" + d.getLocatorId());
        sb.append("\n\tidentityHashCode=" + System.identityHashCode(d));
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer("Descriptor(");
        DescriptorImpl.pretty(sb, this);
        sb.append(")");
        return sb.toString();
    }

    public void writeObject(PrintWriter out) throws IOException {
        out.print(START_START);
        if (this.implementation != null) {
            out.print(this.implementation);
        }
        out.println(END_START);
        if (this.contracts != null && !this.contracts.isEmpty()) {
            out.println(CONTRACT_KEY + ReflectionHelper.writeSet(this.contracts));
        }
        if (this.name != null) {
            out.println(NAME_KEY + this.name);
        }
        if (this.scope != null && !this.scope.equals(PerLookup.class.getName())) {
            out.println(SCOPE_KEY + this.scope);
        }
        if (this.qualifiers != null && !this.qualifiers.isEmpty()) {
            out.println(QUALIFIER_KEY + ReflectionHelper.writeSet(this.qualifiers));
        }
        if (this.descriptorType != null && this.descriptorType.equals((Object)DescriptorType.PROVIDE_METHOD)) {
            out.println("type=FACTORY");
        }
        if (this.descriptorVisibility != null && this.descriptorVisibility.equals((Object)DescriptorVisibility.LOCAL)) {
            out.println("visibility=LOCAL");
        }
        if (this.rank != 0) {
            out.println(RANKING_KEY + this.rank);
        }
        if (this.proxiable != null) {
            out.println(PROXIABLE_KEY + this.proxiable);
        }
        if (this.metadatas != null && !this.metadatas.isEmpty()) {
            out.println(METADATA_KEY + ReflectionHelper.writeMetadata(this.metadatas));
        }
        out.println();
    }

    public boolean readObject(BufferedReader in) throws IOException {
        String line = in.readLine();
        boolean sectionStarted = false;
        while (line != null) {
            String trimmed = line.trim();
            if (!sectionStarted) {
                if (trimmed.startsWith(START_START)) {
                    sectionStarted = true;
                    int endStartIndex = trimmed.indexOf(93, 1);
                    if (endStartIndex < 0) {
                        throw new IOException("Start of implementation ends without ] character: " + trimmed);
                    }
                    if (endStartIndex > 1) {
                        this.implementation = trimmed.substring(1, endStartIndex);
                    }
                }
            } else {
                if (trimmed.length() <= 0) {
                    return true;
                }
                int equalsIndex = trimmed.indexOf(61);
                if (equalsIndex >= 1) {
                    String leftHandSide = trimmed.substring(0, equalsIndex + 1);
                    String rightHandSide = trimmed.substring(equalsIndex + 1);
                    if (leftHandSide.equalsIgnoreCase(CONTRACT_KEY)) {
                        this.contracts = new LinkedHashSet<String>();
                        ReflectionHelper.readSet((String)rightHandSide, this.contracts);
                    } else if (leftHandSide.equals(QUALIFIER_KEY)) {
                        this.qualifiers = new LinkedHashSet<String>();
                        ReflectionHelper.readSet((String)rightHandSide, this.qualifiers);
                    } else if (leftHandSide.equals(NAME_KEY)) {
                        this.name = rightHandSide;
                    } else if (leftHandSide.equals(SCOPE_KEY)) {
                        this.scope = rightHandSide;
                    } else if (leftHandSide.equals(TYPE_KEY)) {
                        if (rightHandSide.equals(FACTORY_DT)) {
                            this.descriptorType = DescriptorType.PROVIDE_METHOD;
                        }
                    } else if (leftHandSide.equals(VISIBILITY_KEY)) {
                        if (rightHandSide.equals(LOCAL_DT)) {
                            this.descriptorVisibility = DescriptorVisibility.LOCAL;
                        }
                    } else if (leftHandSide.equals(METADATA_KEY)) {
                        this.metadatas.clear();
                        ReflectionHelper.readMetadataMap((String)rightHandSide, this.metadatas);
                    } else if (leftHandSide.equals(RANKING_KEY)) {
                        this.rank = Integer.parseInt(rightHandSide);
                    } else if (leftHandSide.equals(PROXIABLE_KEY)) {
                        this.proxiable = Boolean.parseBoolean(rightHandSide);
                    }
                }
            }
            line = in.readLine();
        }
        return sectionStarted;
    }
}

