/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;

public class ServiceLocatorFactoryImpl
extends ServiceLocatorFactory {
    private final ServiceLocatorGenerator defaultGenerator;
    private final Object lock = new Object();
    private final HashMap<String, ServiceLocator> serviceLocators = new HashMap();

    public ServiceLocatorFactoryImpl() {
        this.defaultGenerator = AccessController.doPrivileged(new PrivilegedAction<ServiceLocatorGenerator>(){

            @Override
            public ServiceLocatorGenerator run() {
                return ServiceLocatorFactoryImpl.getGenerator();
            }
        });
    }

    private static ServiceLocatorGenerator getGenerator() {
        Iterator<ServiceLocatorGenerator> providers;
        Iterable generators = org.glassfish.hk2.osgiresourcelocator.ServiceLoader.lookupProviderInstances(ServiceLocatorGenerator.class);
        if (generators != null) {
            for (ServiceLocatorGenerator generator : generators) {
                if (generator == null) continue;
                return generator;
            }
        }
        if ((providers = ServiceLoader.load(ServiceLocatorGenerator.class).iterator()).hasNext()) {
            return providers.next();
        }
        Logger.getLogger(ServiceLocatorFactoryImpl.class.getName()).info("Cannot find a default implementation of the HK2 ServiceLocatorGenerator");
        return null;
    }

    @Override
    public ServiceLocator create(String name) {
        return this.create(name, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceLocator find(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceLocators.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(String name) {
        ServiceLocator killMe = null;
        Object object = this.lock;
        synchronized (object) {
            killMe = this.serviceLocators.remove(name);
        }
        if (killMe != null) {
            killMe.shutdown();
        }
    }

    @Override
    public ServiceLocator create(String name, ServiceLocator parent) {
        return this.create(name, parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceLocator create(String name, ServiceLocator parent, ServiceLocatorGenerator generator) {
        if (generator == null) {
            if (this.defaultGenerator == null) {
                throw new IllegalStateException("No generator was provided and there is no default generator registered");
            }
            generator = this.defaultGenerator;
        }
        Object object = this.lock;
        synchronized (object) {
            ServiceLocator retVal = this.serviceLocators.get(name);
            if (retVal != null) {
                return retVal;
            }
            retVal = generator.create(name, parent);
            this.serviceLocators.put(name, retVal);
            return retVal;
        }
    }
}

