/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerThread;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.internal.PerThreadContext;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;

public abstract class ServiceLocatorUtilities {
    private static final String DEFAULT_LOCATOR_NAME = "default";

    public static void enablePerThreadScope(ServiceLocator locator) {
        Context perThreadContext = (Context)locator.getService(new TypeLiteral<Context<PerThread>>(){}.getType(), new Annotation[0]);
        if (perThreadContext != null) {
            return;
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        DescriptorImpl descriptor = BuilderHelper.link(PerThreadContext.class).to(Context.class).in(Singleton.class.getName()).build();
        ClassLoader loader = ServiceLocatorUtilities.class.getClassLoader();
        final ClassLoader binderClassLoader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        descriptor.setLoader(new HK2Loader(){

            @Override
            public Class<?> loadClass(String className) throws MultiException {
                try {
                    return binderClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new MultiException(e);
                }
            }
        });
        config.bind(descriptor);
        config.commit();
    }

    public static void bind(ServiceLocator locator, Binder ... binders) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        for (Binder binder : binders) {
            binder.bind(config);
        }
        config.commit();
    }

    public static ServiceLocator bind(String name, Binder ... binders) {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        ServiceLocator locator = factory.create(name);
        ServiceLocatorUtilities.bind(locator, binders);
        return locator;
    }

    public static ServiceLocator bind(Binder ... binders) {
        return ServiceLocatorUtilities.bind(DEFAULT_LOCATOR_NAME, binders);
    }

    public static <T> ActiveDescriptor<T> addOneConstant(ServiceLocator locator, Object constant) {
        if (locator == null || constant == null) {
            throw new IllegalArgumentException();
        }
        return ServiceLocatorUtilities.addOneDescriptor(locator, BuilderHelper.createConstantDescriptor(constant));
    }

    public static <T> ActiveDescriptor<T> addOneConstant(ServiceLocator locator, Object constant, String name, Type ... contracts) {
        if (locator == null || constant == null) {
            throw new IllegalArgumentException();
        }
        return ServiceLocatorUtilities.addOneDescriptor(locator, BuilderHelper.createConstantDescriptor(constant, name, contracts));
    }

    public static <T> ActiveDescriptor<T> addOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        ActiveDescriptor active;
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        ActiveDescriptor retVal = descriptor instanceof ActiveDescriptor ? ((active = (ActiveDescriptor)descriptor).isReified() ? config.addActiveDescriptor(active) : config.bind(descriptor)) : config.bind(descriptor);
        config.commit();
        return retVal;
    }

    public static <T> ActiveDescriptor<T> findOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        ActiveDescriptor<?> retVal;
        if (locator == null || descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (descriptor.getServiceId() != null && descriptor.getLocatorId() != null && (retVal = locator.getBestDescriptor(BuilderHelper.createSpecificDescriptorFilter(descriptor))) != null) {
            return retVal;
        }
        final DescriptorImpl di = descriptor instanceof DescriptorImpl ? (DescriptorImpl)descriptor : new DescriptorImpl(descriptor);
        ActiveDescriptor<?> retVal2 = locator.getBestDescriptor(new Filter(){

            @Override
            public boolean matches(Descriptor d) {
                return di.equals(d);
            }
        });
        return retVal2;
    }

    public static void removeOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        if (locator == null || descriptor == null) {
            throw new IllegalArgumentException();
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        if (descriptor.getLocatorId() != null && descriptor.getServiceId() != null) {
            IndexedFilter destructionFilter = BuilderHelper.createSpecificDescriptorFilter(descriptor);
            config.addUnbindFilter(destructionFilter);
            config.commit();
            return;
        }
        final DescriptorImpl di = descriptor instanceof DescriptorImpl ? (DescriptorImpl)descriptor : new DescriptorImpl(descriptor);
        Filter destructionFilter = new Filter(){

            @Override
            public boolean matches(Descriptor d) {
                return di.equals(d);
            }
        };
        config.addUnbindFilter(destructionFilter);
        config.commit();
    }

    public static void removeFilter(ServiceLocator locator, Filter filter) {
        if (locator == null || filter == null) {
            throw new IllegalArgumentException();
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter(filter);
        config.commit();
    }
}

