/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;

public class ServiceLocatorFactoryImpl
extends ServiceLocatorFactory {
    private final ServiceLocatorGenerator defaultGenerator;
    private final Object lock = new Object();
    private final HashMap<String, ServiceLocator> serviceLocators = new HashMap();
    private static int name_count = 0;
    private static final String GENERATED_NAME_PREFIX = "__HK2_Generated_";
    private static Logger logger = Logger.getLogger(ServiceLocatorFactoryImpl.class.getPackage().getName());

    public ServiceLocatorFactoryImpl() {
        this.defaultGenerator = AccessController.doPrivileged(new PrivilegedAction<ServiceLocatorGenerator>(){

            @Override
            public ServiceLocatorGenerator run() {
                try {
                    return ServiceLocatorFactoryImpl.getGenerator();
                }
                catch (Throwable th) {
                    Logger.getLogger(ServiceLocatorFactoryImpl.class.getName()).warning("Error finding implementation of hk2: " + th.getMessage());
                    return null;
                }
            }
        });
    }

    private static ServiceLocatorGenerator getGenerator() {
        Iterable generators = org.glassfish.hk2.osgiresourcelocator.ServiceLoader.lookupProviderInstances(ServiceLocatorGenerator.class);
        if (generators != null) {
            Iterator iterator = generators.iterator();
            return iterator.hasNext() ? (ServiceLocatorGenerator)iterator.next() : null;
        }
        Iterator<ServiceLocatorGenerator> providers = ServiceLoader.load(ServiceLocatorGenerator.class).iterator();
        while (providers.hasNext()) {
            try {
                return providers.next();
            }
            catch (ServiceConfigurationError sce) {
                logger.logp(Level.FINE, "ServiceLocatorFactoryImpl", "getGenerator", "Exception while looking up service locator generator", sce);
            }
        }
        logger.warning("Cannot find a default implementation of the HK2 ServiceLocatorGenerator");
        return null;
    }

    @Override
    public ServiceLocator create(String name) {
        return this.create(name, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceLocator find(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceLocators.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(String name) {
        ServiceLocator killMe = null;
        Object object = this.lock;
        synchronized (object) {
            killMe = this.serviceLocators.remove(name);
        }
        if (killMe != null) {
            killMe.shutdown();
        }
    }

    @Override
    public ServiceLocator create(String name, ServiceLocator parent) {
        return this.create(name, parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceLocator create(String name, ServiceLocator parent, ServiceLocatorGenerator generator) {
        Object object = this.lock;
        synchronized (object) {
            if (name == null) {
                name = GENERATED_NAME_PREFIX + name_count++;
                return this.internalCreate(name, parent, generator);
            }
            ServiceLocator retVal = this.serviceLocators.get(name);
            if (retVal != null) {
                return retVal;
            }
            retVal = this.internalCreate(name, parent, generator);
            this.serviceLocators.put(name, retVal);
            return retVal;
        }
    }

    private ServiceLocator internalCreate(String name, ServiceLocator parent, ServiceLocatorGenerator generator) {
        if (generator == null) {
            if (this.defaultGenerator == null) {
                throw new IllegalStateException("No generator was provided and there is no default generator registered");
            }
            generator = this.defaultGenerator;
        }
        return generator.create(name, parent);
    }
}

