/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.internal.ConstantActiveDescriptor;
import org.glassfish.hk2.internal.DescriptorBuilderImpl;
import org.glassfish.hk2.internal.IndexedFilterImpl;
import org.glassfish.hk2.internal.ReflectionHelper;
import org.glassfish.hk2.internal.StarFilter;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.DescriptorBuilder;
import org.glassfish.hk2.utilities.DescriptorImpl;

public class BuilderHelper {
    public static IndexedFilter createContractFilter(String contract) {
        return new IndexedFilterImpl(contract, null);
    }

    public static IndexedFilter createNameFilter(String name) {
        return new IndexedFilterImpl(null, name);
    }

    public static IndexedFilter createNameAndContractFilter(String contract, String name) {
        return new IndexedFilterImpl(contract, name);
    }

    public static Filter allFilter() {
        return StarFilter.getDescriptorFilter();
    }

    public static DescriptorBuilder link(String implementationClass, boolean addToContracts) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        return new DescriptorBuilderImpl(implementationClass, addToContracts);
    }

    public static DescriptorBuilder link(String implementationClass) throws IllegalArgumentException {
        return BuilderHelper.link(implementationClass, true);
    }

    public static DescriptorBuilder link(Class<?> implementationClass, boolean addToContracts) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        DescriptorBuilder builder = BuilderHelper.link(implementationClass.getName(), addToContracts);
        return builder;
    }

    public static DescriptorBuilder link(Class<?> implementationClass) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        boolean isFactory = Factory.class.isAssignableFrom(implementationClass);
        DescriptorBuilder db = BuilderHelper.link(implementationClass, !isFactory);
        if (isFactory) {
            db = db.to(Factory.class);
        }
        return db;
    }

    public static <T> AbstractActiveDescriptor<T> createConstantDescriptor(T constant) {
        if (constant == null) {
            throw new IllegalArgumentException();
        }
        return new ConstantActiveDescriptor<T>(constant, ReflectionHelper.getAdvertisedTypesFromObject(constant), ReflectionHelper.getScopeFromObject(constant), ReflectionHelper.getName(constant.getClass()), ReflectionHelper.getQualifiersFromObject(constant));
    }

    public static DescriptorImpl createDescriptorFromClass(Class<?> clazz) {
        if (clazz == null) {
            return new DescriptorImpl();
        }
        Set<String> contracts = ReflectionHelper.getContractsFromClass(clazz);
        String name = ReflectionHelper.getName(clazz);
        String scope = ReflectionHelper.getScopeFromClass(clazz).getName();
        Set<String> qualifiers = ReflectionHelper.getQualifiersFromClass(clazz);
        DescriptorType type = DescriptorType.CLASS;
        if (Factory.class.isAssignableFrom(clazz)) {
            type = DescriptorType.FACTORY;
        }
        return new DescriptorImpl(contracts, name, scope, clazz.getName(), new HashMap<String, List<String>>(), qualifiers, type, null, 0, null, null, null);
    }

    public static Descriptor deepCopyDescriptor(Descriptor copyMe) {
        return new DescriptorImpl(copyMe);
    }
}

