/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Contract;

public class ReflectionHelper {
    public static Class<?> getRawClass(Type type) {
        Type rawType;
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private static String getNamedName(Named named, Class<?> implClass) {
        String name = named.value();
        if (name != null && !name.equals("")) {
            return name;
        }
        String cn = implClass.getName();
        int index = cn.lastIndexOf(".");
        if (index < 0) {
            return cn;
        }
        return cn.substring(index + 1);
    }

    public static String getName(Class<?> implClass) {
        String namedName;
        Named named = implClass.getAnnotation(Named.class);
        String string = namedName = named != null ? ReflectionHelper.getNamedName(named, implClass) : null;
        if (namedName != null) {
            return namedName;
        }
        return null;
    }

    public static Set<Type> getAdvertisedTypesFromObject(Object t) {
        Type[] genericInterfaces;
        HashSet<Type> retVal = new HashSet<Type>();
        if (t == null) {
            return retVal;
        }
        retVal.add(t.getClass());
        for (Type genericInterface : genericInterfaces = t.getClass().getGenericInterfaces()) {
            Class<?> rawClass = ReflectionHelper.getRawClass(genericInterface);
            if (rawClass == null || !rawClass.isAnnotationPresent(Contract.class)) continue;
            retVal.add(genericInterface);
        }
        return retVal;
    }

    public static Class<? extends Annotation> getScopeFromObject(Object t) {
        if (t == null) {
            return PerLookup.class;
        }
        Class<?> oClass = t.getClass();
        for (Annotation annotation : oClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (!annoClass.isAnnotationPresent(Scope.class)) continue;
            return annoClass;
        }
        return PerLookup.class;
    }

    public static Set<Annotation> getQualifiersFromObject(Object t) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        if (t == null) {
            return retVal;
        }
        Class<?> oClass = t.getClass();
        for (Annotation annotation : oClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (!annoClass.isAnnotationPresent(Qualifier.class)) continue;
            retVal.add(annotation);
        }
        return retVal;
    }
}

