/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.HK2Loader;

public class DescriptorImpl
implements Descriptor,
Serializable {
    private static final long serialVersionUID = 77937523212000548L;
    private Set<String> contracts;
    private String implementation;
    private String name;
    private String scope;
    private Map<String, List<String>> metadatas;
    private Set<String> qualifiers;
    private DescriptorType descriptorType;
    private HK2Loader loader;
    private int rank;
    private Long id;
    private Long locatorId;

    public DescriptorImpl() {
    }

    public DescriptorImpl(Descriptor copyMe) {
        this.contracts = copyMe.getAdvertisedContracts();
        this.name = copyMe.getName();
        this.scope = copyMe.getScope();
        this.implementation = copyMe.getImplementation();
        this.qualifiers = copyMe.getQualifiers();
        this.descriptorType = copyMe.getDescriptorType();
        this.loader = copyMe.getLoader();
        this.metadatas = copyMe.getMetadata();
        this.rank = copyMe.getRanking();
        this.id = copyMe.getServiceId();
        this.locatorId = copyMe.getLocatorId();
    }

    public DescriptorImpl(Set<String> contracts, String name, String scope, String implementation, Map<String, List<String>> metadatas, Set<String> qualifiers, DescriptorType descriptorType, HK2Loader loader, int rank, Long id, Long locatorId) {
        this.contracts = new HashSet<String>(contracts);
        this.implementation = implementation;
        this.name = name;
        this.scope = scope;
        this.metadatas = new HashMap<String, List<String>>(metadatas);
        this.qualifiers = new HashSet<String>(qualifiers);
        this.descriptorType = descriptorType;
        this.id = id;
        this.rank = rank;
        this.locatorId = locatorId;
        this.loader = loader;
    }

    @Override
    public Set<String> getAdvertisedContracts() {
        return Collections.unmodifiableSet(this.contracts);
    }

    @Override
    public String getImplementation() {
        return this.implementation;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getQualifiers() {
        return new HashSet<String>(this.qualifiers);
    }

    @Override
    public DescriptorType getDescriptorType() {
        return this.descriptorType;
    }

    @Override
    public Map<String, List<String>> getMetadata() {
        return new HashMap<String, List<String>>(this.metadatas);
    }

    @Override
    public HK2Loader getLoader() {
        return this.loader;
    }

    @Override
    public int getRanking() {
        return this.rank;
    }

    @Override
    public int setRanking(int ranking) {
        int retVal = this.rank;
        this.rank = ranking;
        return retVal;
    }

    @Override
    public Long getServiceId() {
        return this.id;
    }

    @Override
    public Long getLocatorId() {
        return this.locatorId;
    }

    private static String writeSet(Set<?> set) {
        StringBuffer sb = new StringBuffer("{");
        boolean first = true;
        for (Object writeMe : set) {
            if (first) {
                first = false;
                sb.append(writeMe.toString());
                continue;
            }
            sb.append("," + writeMe.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    private static String writeList(List<String> list) {
        StringBuffer sb = new StringBuffer("[");
        boolean first = true;
        for (String writeMe : list) {
            if (first) {
                first = false;
                sb.append(writeMe.toString());
                continue;
            }
            sb.append("," + writeMe.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private static String writeMetadata(Map<String, List<String>> metadata) {
        StringBuffer sb = new StringBuffer("{");
        boolean first = true;
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            if (first) {
                first = false;
                sb.append(entry.getKey() + "=");
            } else {
                sb.append("," + entry.getKey() + "=");
            }
            sb.append(DescriptorImpl.writeList(entry.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DescriptorImpl(");
        sb.append("\n\timplementation=" + this.implementation);
        if (this.name != null) {
            sb.append("\n\tname=" + this.name);
        }
        sb.append("\n\tcontracts=");
        sb.append(DescriptorImpl.writeSet(this.contracts));
        sb.append("\n\tscope=" + this.scope);
        sb.append("\n\tqualifiers=");
        sb.append(DescriptorImpl.writeSet(this.qualifiers));
        sb.append("\n\tdescriptorType=" + (Object)((Object)this.descriptorType));
        sb.append("\n\tmetadata=");
        sb.append(DescriptorImpl.writeMetadata(this.metadatas));
        sb.append("\n\tloader=" + this.loader);
        sb.append("\n\tid=" + this.id);
        sb.append("\n\tlocatorId=" + this.locatorId);
        sb.append(")");
        return sb.toString();
    }
}

