/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ClassType;
import org.hibernate.validator.internal.xml.ConstraintType;
import org.hibernate.validator.internal.xml.GroupSequenceType;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;

class ConstrainedTypeBuilder {
    private ConstrainedTypeBuilder() {
    }

    static ConstrainedType buildConstrainedType(ClassType classType, Class<?> beanClass, String defaultPackage, ConstraintHelper constraintHelper, AnnotationProcessingOptionsImpl annotationProcessingOptions, Map<Class<?>, List<Class<?>>> defaultSequences) {
        if (classType == null) {
            return null;
        }
        List<Class<?>> groupSequence = ConstrainedTypeBuilder.createGroupSequence(classType.getGroupSequence(), defaultPackage);
        if (!groupSequence.isEmpty()) {
            defaultSequences.put(beanClass, groupSequence);
        }
        ConstraintLocation constraintLocation = ConstraintLocation.forClass(beanClass);
        HashSet<MetaConstraint<?>> metaConstraints = CollectionHelper.newHashSet();
        for (ConstraintType constraint : classType.getConstraint()) {
            MetaConstraint metaConstraint = MetaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.TYPE, defaultPackage, constraintHelper, null);
            metaConstraints.add(metaConstraint);
        }
        if (classType.getIgnoreAnnotations() != null) {
            annotationProcessingOptions.ignoreClassLevelConstraintAnnotations(beanClass, classType.getIgnoreAnnotations());
        }
        return new ConstrainedType(ConfigurationSource.XML, constraintLocation, metaConstraints);
    }

    private static List<Class<?>> createGroupSequence(GroupSequenceType groupSequenceType, String defaultPackage) {
        ArrayList<Class<?>> groupSequence = CollectionHelper.newArrayList();
        if (groupSequenceType != null) {
            for (String groupName : groupSequenceType.getValue()) {
                Class<?> group = ClassLoadingHelper.loadClass(groupName, defaultPackage);
                groupSequence.add(group);
            }
        }
        return groupSequence;
    }
}

