/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.examples.http.AlternateInject;
import org.glassfish.examples.http.HttpParameter;
import org.glassfish.examples.http.HttpRequest;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;

@Singleton
public class AlternateInjectResolver
implements InjectionResolver<AlternateInject> {
    @Inject
    @Named(value="SystemInjectResolver")
    private InjectionResolver<Inject> systemResolver;
    @Inject
    private HttpRequest request;

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        AnnotatedElement parent = injectee.getParent();
        if (!(parent instanceof Method)) {
            throw new AssertionError((Object)"The AlternateInjectionResolver only works on methods (for now)");
        }
        Method method = (Method)parent;
        Annotation[] annotations = method.getParameterAnnotations()[injectee.getPosition()];
        HttpParameter httpParam = AlternateInjectResolver.getHttpParameter(annotations);
        if (httpParam == null) {
            return this.systemResolver.resolve(injectee, root);
        }
        int index = httpParam.value();
        String fromRequest = this.request.getPathElement(index);
        if (fromRequest == null) {
            throw new AssertionError((Object)("There should have been a value at index " + index));
        }
        Class<?> injecteeType = method.getParameterTypes()[injectee.getPosition()];
        if (Integer.TYPE.equals(injecteeType)) {
            return Integer.parseInt(fromRequest);
        }
        if (Long.TYPE.equals(injecteeType)) {
            return Long.parseLong(fromRequest);
        }
        if (String.class.equals(injecteeType)) {
            return fromRequest;
        }
        throw new AssertionError((Object)("Unknown type conversion: " + injecteeType));
    }

    private static HttpParameter getHttpParameter(Annotation[] annotations) {
        for (Annotation anno : annotations) {
            if (!HttpParameter.class.equals(anno.annotationType())) continue;
            return (HttpParameter)anno;
        }
        return null;
    }

    public boolean isConstructorParameterIndicator() {
        return false;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

