/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.signature.SignatureVisitor;

public class SignatureVisitorImpl
implements SignatureVisitor {
    final TypeBuilder typeBuilder;
    final Stack<ParameterizedInterfaceModelImpl> stack = new Stack();
    final Map<String, ParameterizedInterfaceModelImpl> formalTypes = new HashMap<String, ParameterizedInterfaceModelImpl>();
    final Stack<String> formalTypesNames = new Stack();
    ParameterizedInterfaceModel lastElement;

    public SignatureVisitorImpl(TypeBuilder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    ParameterizedInterfaceModel getTopElement() {
        return this.lastElement;
    }

    public void visitFormalTypeParameter(String s) {
        System.out.println("Visiting formal type " + s);
        this.formalTypesNames.push(s);
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        return this;
    }

    public SignatureVisitor visitReturnType() {
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        return this;
    }

    public void visitBaseType(char c) {
    }

    public void visitTypeVariable(String s) {
        System.out.println("Visiting type variable" + s + " and its type is " + this.formalTypes.get(s).getName());
        if (this.formalTypes.containsKey(s)) {
            String interfaceName = this.formalTypes.get(s).getName();
            TypeProxy<InterfaceModel> interfaceTypeProxy = this.typeBuilder.getHolder(interfaceName, InterfaceModel.class);
            ParameterizedInterfaceModelImpl childParameterized = new ParameterizedInterfaceModelImpl(interfaceTypeProxy);
            this.stack.peek().addParameterizedType(childParameterized);
        }
    }

    public SignatureVisitor visitArrayType() {
        return this;
    }

    public void visitClassType(String s) {
        System.out.println("Visiting class type " + s);
        TypeProxy<InterfaceModel> interfaceTypeProxy = this.typeBuilder.getHolder(s, InterfaceModel.class);
        ParameterizedInterfaceModelImpl childParameterized = new ParameterizedInterfaceModelImpl(interfaceTypeProxy);
        if (!s.equals("java/lang/Object")) {
            if (this.formalTypesNames.empty()) {
                if (!this.stack.empty()) {
                    this.stack.peek().addParameterizedType(childParameterized);
                }
            } else {
                this.formalTypes.put(this.formalTypesNames.pop(), childParameterized);
            }
        }
        this.stack.push(childParameterized);
    }

    public void visitInnerClassType(String s) {
    }

    public void visitTypeArgument() {
    }

    public SignatureVisitor visitTypeArgument(char c) {
        return this;
    }

    public void visitEnd() {
        System.out.println("Visit end");
        this.lastElement = this.stack.pop();
    }
}

