/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ExtensibleTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.FieldModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ModelClassVisitor
implements ClassVisitor {
    private static Logger logger = Logger.getLogger(ModelClassVisitor.class.getName());
    private final ParsingContext ctx;
    private final TypeBuilder typeBuilder;
    private final URI definingURI;
    private final String entryName;
    TypeImpl type;
    boolean deepVisit = false;
    private final ClassVisitingContext classContext;
    private final MemberVisitingContext visitingContext;
    private final ModelFieldVisitor fieldVisitor;
    private final ModelMethodVisitor methodVisitor;
    private final ModelAnnotationVisitor annotationVisitor;
    private final ModelDefaultAnnotationVisitor defaultAnnotationVisitor;
    private static int discarded = 0;

    public ModelClassVisitor(ParsingContext ctx, URI definingURI, String entryName) {
        this.ctx = ctx;
        this.definingURI = definingURI;
        this.entryName = entryName;
        this.typeBuilder = ctx.getTypeBuilder(definingURI);
        this.classContext = new ClassVisitingContext();
        this.visitingContext = new MemberVisitingContext(ctx.getConfig().modelUnAnnotatedMembers());
        this.fieldVisitor = new ModelFieldVisitor(this.visitingContext);
        this.methodVisitor = new ModelMethodVisitor(this.visitingContext);
        this.annotationVisitor = new ModelAnnotationVisitor();
        this.defaultAnnotationVisitor = new ModelDefaultAnnotationVisitor(this.methodVisitor.getContext());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        TypeProxy<? extends Type> parent;
        String parentName = superName != null ? org.objectweb.asm.Type.getObjectType((String)superName).getClassName() : null;
        TypeProxy<? extends Type> typeProxy = parent = parentName != null ? this.typeBuilder.getHolder(parentName, this.typeBuilder.getType(access)) : null;
        if (parent != null && !parentName.equals(Object.class.getName())) {
            TypeImpl parentType = this.typeBuilder.getType(access, parentName, null);
            parent.set(parentType);
        }
        String className = org.objectweb.asm.Type.getObjectType((String)name).getClassName();
        URI classDefURI = null;
        try {
            int index = this.entryName.length() - name.length() - 6;
            if (null == this.definingURI || index == 0) {
                classDefURI = this.definingURI;
            } else {
                String newPath = index > 0 ? this.definingURI.getPath() + this.entryName.substring(0, index) : this.definingURI.getPath();
                classDefURI = new URI(this.definingURI.getScheme(), newPath, this.definingURI.getFragment());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "visiting {0} with classDefURI={1}", new Object[]{this.entryName, classDefURI});
        }
        this.type = this.ctx.getTypeBuilder(classDefURI).getType(access, className, parent);
        this.type.getProxy().visited();
        this.type.addDefiningURI(classDefURI);
        this.deepVisit = this.ctx.getConfig().getAnnotationsOfInterest().isEmpty();
        this.classContext.type = this.type;
        this.classContext.interfaces = interfaces;
        this.classContext.parent = parent;
        if (parent != null) {
            parent.addSubTypeRef(this.type);
        }
        try {
            ExtensibleTypeImpl classModel = (ExtensibleTypeImpl)this.type;
            for (String intf : interfaces) {
                String interfaceName = org.objectweb.asm.Type.getObjectType((String)intf).getClassName();
                TypeProxy<InterfaceModel> typeProxy2 = this.typeBuilder.getHolder(interfaceName, InterfaceModel.class);
                ParameterizedInterfaceModelImpl pim = new ParameterizedInterfaceModelImpl(typeProxy2);
                if (signature == null || className.contains("parameterized")) {
                    // empty if block
                }
                classModel.isImplementing(typeProxy2);
                if (!(classModel instanceof ClassModel)) continue;
                typeProxy2.addImplementation((ClassModel)((Object)classModel));
            }
        }
        catch (ClassCastException e) {
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        desc = this.unwrap(desc);
        AnnotationTypeImpl at = (AnnotationTypeImpl)this.typeBuilder.getType(8192, desc, null);
        AnnotationModelImpl am = new AnnotationModelImpl(this.type, at);
        at.getAnnotatedElements().add(this.type);
        this.type.addAnnotation(am);
        if (this.ctx.getConfig().getAnnotationsOfInterest().contains(desc)) {
            logger.log(Level.FINER, "Inspecting fields of {0}", this.type.getName());
            this.deepVisit = true;
        }
        this.annotationVisitor.getContext().annotation = am;
        return this.annotationVisitor;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldModelImpl field;
        if (!this.deepVisit) {
            return null;
        }
        if (!(this.type instanceof ExtensibleTypeImpl)) {
            logger.severe("Field visitor invoked for field " + name + "in type " + this.type.getName() + " which is not a ClassModel type instance but a " + this.type.getClass().getName());
            return null;
        }
        ExtensibleTypeImpl cm = (ExtensibleTypeImpl)this.type;
        org.objectweb.asm.Type asmType = org.objectweb.asm.Type.getType((String)desc);
        TypeProxy fieldType = this.typeBuilder.getHolder(asmType.getClassName());
        this.fieldVisitor.getContext().field = field = this.typeBuilder.getFieldModel(name, fieldType, cm);
        this.fieldVisitor.getContext().typeDesc = desc;
        this.fieldVisitor.getContext().access = access;
        this.fieldVisitor.getContext().classModel = cm;
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.deepVisit) {
            return null;
        }
        if (!(this.type instanceof ExtensibleType)) {
            logger.severe("Method visitor invoked for method " + name + "in type " + this.type.getName() + " which is not an ExtensibleType type instance but a " + this.type.getClass().getName());
            return null;
        }
        ExtensibleType cm = (ExtensibleType)((Object)this.type);
        this.methodVisitor.getContext().method = new MethodModelImpl(name, cm, signature == null ? desc : signature);
        return this.methodVisitor;
    }

    public void visitEnd() {
        this.type = null;
    }

    private String unwrap(String desc) {
        return org.objectweb.asm.Type.getType((String)desc).getClassName();
    }

    private class ModelAnnotationVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private final AnnotationVisitingContext context = new AnnotationVisitingContext();

        private ModelAnnotationVisitor() {
        }

        AnnotationVisitingContext getContext() {
            return this.context;
        }

        public void visit(String name, Object value) {
            if (this.context.annotation == null) {
                return;
            }
            this.context.annotation.addValue(name, value);
        }

        public void visitEnd() {
        }
    }

    private class ModelFieldVisitor
    extends EmptyVisitor
    implements FieldVisitor {
        private final FieldVisitingContext context;

        private ModelFieldVisitor(MemberVisitingContext context) {
            this.context = new FieldVisitingContext(context.modelUnAnnotatedMembers);
        }

        FieldVisitingContext getContext() {
            return this.context;
        }

        public AnnotationVisitor visitAnnotation(String s, boolean b) {
            FieldModelImpl field = this.context.field;
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(s), null);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(field, annotationType);
            annotationType.getAnnotatedElements().add(field);
            field.addAnnotation(annotationModel);
            ((ModelClassVisitor)ModelClassVisitor.this).annotationVisitor.getContext().annotation = annotationModel;
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            if (this.context.modelUnAnnotatedMembers || !this.context.field.getAnnotations().isEmpty()) {
                this.context.field.type.addFieldRef(this.context.field);
                if ((8 & this.context.access) == 8) {
                    this.context.classModel.addStaticField(this.context.field);
                } else {
                    this.context.classModel.addField(this.context.field);
                }
            }
            this.context.field = null;
        }
    }

    private class ModelDefaultAnnotationVisitor
    extends EmptyVisitor
    implements AnnotationVisitor {
        private final MethodVisitingContext context;

        public ModelDefaultAnnotationVisitor(MethodVisitingContext visitingContext) {
            this.context = visitingContext;
        }

        public void visit(String desc, Object value) {
            AnnotationTypeImpl am = (AnnotationTypeImpl)this.context.method.owner;
            am.addDefaultValue(this.context.method.name, value);
        }
    }

    private class ModelMethodVisitor
    extends EmptyVisitor
    implements MethodVisitor {
        private final MethodVisitingContext context;

        private ModelMethodVisitor(MemberVisitingContext context) {
            this.context = new MethodVisitingContext(context.modelUnAnnotatedMembers);
        }

        MethodVisitingContext getContext() {
            return this.context;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.context.method == null) {
                return null;
            }
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(desc), null);
            AnnotationModelImpl am = new AnnotationModelImpl(this.context.method, annotationType);
            annotationType.getAnnotatedElements().add(this.context.method);
            this.context.method.addAnnotation(am);
            ((ModelClassVisitor)ModelClassVisitor.this).annotationVisitor.getContext().annotation = am;
            return ModelClassVisitor.this.annotationVisitor;
        }

        public void visitEnd() {
            if (this.context.modelUnAnnotatedMembers || !this.context.method.getAnnotations().isEmpty()) {
                ModelClassVisitor.this.type.addMethod(this.context.method);
            }
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return ModelClassVisitor.this.defaultAnnotationVisitor;
        }
    }

    private static class AnnotationVisitingContext {
        AnnotationModelImpl annotation;

        private AnnotationVisitingContext() {
        }
    }

    private static class MethodVisitingContext
    extends MemberVisitingContext {
        MethodModelImpl method;

        private MethodVisitingContext(boolean modelUnAnnotatedMembers) {
            super(modelUnAnnotatedMembers);
        }
    }

    private static class FieldVisitingContext
    extends MemberVisitingContext {
        FieldModelImpl field;
        String typeDesc;
        ExtensibleTypeImpl classModel;
        int access;

        private FieldVisitingContext(boolean modelUnAnnotatedMembers) {
            super(modelUnAnnotatedMembers);
        }
    }

    private static class MemberVisitingContext {
        final boolean modelUnAnnotatedMembers;

        private MemberVisitingContext(boolean modelUnAnnotatedMembers) {
            this.modelUnAnnotatedMembers = modelUnAnnotatedMembers;
        }
    }

    private static class ClassVisitingContext {
        TypeImpl type;
        TypeProxy parent;
        String[] interfaces;

        private ClassVisitingContext() {
        }
    }
}

