/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class AnnotatedElementImpl
implements AnnotatedElement {
    public final String name;
    public final List<AnnotationModel> annotations = new ArrayList<AnnotationModel>();

    public AnnotatedElementImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    synchronized void addAnnotation(AnnotationModel annotation) {
        this.annotations.add(annotation);
    }

    @Override
    public Collection<AnnotationModel> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public AnnotationModel getAnnotation(String name) {
        for (AnnotationModel am : this.annotations) {
            if (!am.getType().getName().equals(name)) continue;
            return am;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName()).append("{");
        this.print(sb);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String shortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append(this.getName());
        sb.append("}");
        return sb.toString();
    }

    protected void print(StringBuffer sb) {
        sb.append("name='").append(this.name).append("', annotations=");
        sb.append("[");
        for (AnnotationModel am : this.getAnnotations()) {
            sb.append(" ").append(am.getType().getName());
        }
        sb.append("]");
    }
}

