/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

public class TypesCtr
implements Types {
    private final Map<Class, Map<String, TypeProxy<Type>>> storage = new HashMap<Class, Map<String, TypeProxy<Type>>>();
    private final Stack<TypeProxy> nonVisited = new Stack();

    @Override
    public Type getBy(String name) {
        for (Map<String, TypeProxy<Type>> map : this.storage.values()) {
            TypeProxy<Type> proxy = map.get(name);
            if (proxy == null) continue;
            return proxy.get();
        }
        return null;
    }

    @Override
    public <T extends Type> T getBy(Class<T> type, String name) {
        Type t = this.getBy(name);
        try {
            return (T)((Type)type.cast(t));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public synchronized <T extends Type> TypeProxy<Type> getHolder(String name, Class<T> type) {
        TypeProxy<Type> typeProxy;
        Map<String, TypeProxy<Type>> typeStorage = this.storage.get(type);
        if (typeStorage == null) {
            typeStorage = new HashMap<String, TypeProxy<Type>>();
            this.storage.put(type, typeStorage);
        }
        if ((typeProxy = typeStorage.get(name)) == null) {
            typeProxy = new TypeProxy(null, name);
            this.nonVisited.push(typeProxy);
            typeStorage.put(name, typeProxy);
        }
        return typeProxy;
    }

    public void onNotVisitedEntries(ProxyTask proxyTask) {
        while (!this.nonVisited.isEmpty()) {
            TypeProxy proxy = this.nonVisited.pop();
            if (proxy.isVisited()) continue;
            proxyTask.on(proxy);
        }
    }

    @Override
    public Collection<Type> getAllTypes() {
        ArrayList<Type> allTypes = new ArrayList<Type>();
        for (Map<String, TypeProxy<Type>> map : this.storage.values()) {
            for (TypeProxy<Type> typeProxy : map.values()) {
                if (typeProxy.get() == null) continue;
                allTypes.add(typeProxy.get());
            }
        }
        return allTypes;
    }

    public static interface ProxyTask {
        public void on(TypeProxy<?> var1);
    }
}

