/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Type;

public class TypeProxy<T extends Type> {
    private T value = null;
    private volatile boolean visited = false;
    private final String name;
    private final Notifier<T> notifier;
    private final Set<Member> fieldRefs;
    private final Set<Type> subTypeRefs;
    private final Set<ClassModel> implementations = Collections.synchronizedSet(new HashSet());

    TypeProxy(Notifier<T> notifier, String name) {
        this.notifier = notifier;
        this.name = name;
        this.fieldRefs = Collections.synchronizedSet(new HashSet());
        this.subTypeRefs = Collections.synchronizedSet(new HashSet());
    }

    public String toString() {
        return "TypeProxy:" + this.name;
    }

    public void set(T value) {
        this.value = value;
        if (this.notifier != null) {
            this.notifier.valueSet(value);
        }
    }

    public T get() {
        return this.value;
    }

    public String getName() {
        if (this.value != null) {
            return this.value.getName();
        }
        return this.name;
    }

    public Set<Member> getRefs() {
        return this.fieldRefs;
    }

    public Set<Type> getSubTypeRefs() {
        return this.subTypeRefs;
    }

    public Set<ClassModel> getImplementations() {
        return this.implementations;
    }

    public static <U extends Type> Collection<U> adapter(final Collection<TypeProxy<U>> source) {
        return new AbstractCollection<U>(){

            @Override
            public Iterator<U> iterator() {
                final Iterator itr = source.iterator();
                return new Iterator<U>(){

                    @Override
                    public boolean hasNext() {
                        return itr.hasNext();
                    }

                    @Override
                    public U next() {
                        return ((TypeProxy)itr.next()).get();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return source.size();
            }
        };
    }

    public void visited() {
        this.visited = true;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public static interface Notifier<T> {
        public void valueSet(T var1);
    }
}

