/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.InputStreamArchiveAdapter;

public class JarArchive
extends AbstractAdapter {
    private final JarFile jar;
    private final URI uri;

    public JarArchive(URI uri) throws IOException {
        File f = new File(uri);
        this.uri = uri;
        this.jar = new JarFile(f);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger) throws IOException {
        byte[] bytes = new byte[52000];
        Enumeration<JarEntry> enumEntries = this.jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry ja = enumEntries.nextElement();
            if (ja.getName().endsWith(".jar")) {
                InputStreamArchiveAdapter subArchive = null;
                try {
                    URI subURI = null;
                    try {
                        subURI = new URI("jar:" + this.uri + "!/" + ja.getName());
                    }
                    catch (URISyntaxException e) {
                        try {
                            subURI = new URI(ja.getName());
                        }
                        catch (URISyntaxException e1) {
                            // empty catch block
                        }
                    }
                    subArchive = new InputStreamArchiveAdapter(subURI, this.jar.getInputStream(this.jar.getEntry(ja.getName())));
                    subArchive.onSelectedEntries(selector, task, logger);
                }
                finally {
                    if (subArchive != null) {
                        subArchive.close();
                    }
                }
            }
            InputStream is = null;
            try {
                ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(ja.getName(), ja.getSize(), ja.isDirectory());
                if (!selector.isSelected(entry)) continue;
                is = this.jar.getInputStream(ja);
                try {
                    task.on(entry, is);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while processing " + ja.getName() + " inside " + this.jar.getName() + " of size " + ja.getSize(), e);
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jar.getManifest();
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }
}

