/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveSelector;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.impl.ModelClassVisitor;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypesCtr;
import org.glassfish.hk2.classmodel.reflect.impl.TypesImpl;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.objectweb.asm.ClassVisitor;

public class ParsingContext {
    private final TypesCtr types = new TypesCtr();
    final ExecutorService executorService;
    final ArchiveSelector archiveSelector;
    final Logger logger;
    final ParsingConfig config;
    Map<URI, TypeBuilder> builders = new HashMap<URI, TypeBuilder>();

    private ParsingContext(Builder builder) {
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        this.executorService = builder.executorService;
        this.archiveSelector = builder.archiveSelector;
        this.logger = builder.logger;
        this.config = builder.config != null ? builder.config : new ParsingConfig(){
            final Set<String> emptyList = Collections.emptySet();

            @Override
            public Set<String> getInjectionTargetAnnotations() {
                return this.emptyList;
            }

            @Override
            public Set<String> getInjectionTargetInterfaces() {
                return this.emptyList;
            }

            @Override
            public Set<String> getInjectionPointsAnnotations() {
                return this.emptyList;
            }
        };
    }

    public ParsingContext(ParsingContext parent) {
        this.executorService = parent.executorService;
        this.archiveSelector = parent.archiveSelector;
        this.logger = parent.logger;
        this.config = parent.config;
    }

    public synchronized TypeBuilder getTypeBuilder(URI definingURI) {
        TypeBuilder builder = this.builders.get(definingURI);
        if (builder == null) {
            builder = new TypesImpl(this.types, definingURI);
            this.builders.put(definingURI, builder);
        }
        return builder;
    }

    public Types getTypes() {
        return this.types;
    }

    public ClassVisitor getClassVisitor(URI uri, String entryName) {
        return new ModelClassVisitor(this, uri, entryName);
    }

    public ParsingConfig getConfig() {
        return this.config;
    }

    public static class Builder {
        Logger logger = Logger.getLogger("org.glassfish.classmodel");
        ExecutorService executorService = null;
        ArchiveSelector archiveSelector = null;
        ParsingConfig config = null;

        public Logger logger() {
            return this.logger;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder executorService(ExecutorService service) {
            this.executorService = service;
            return this;
        }

        public Builder archiveSelector(ArchiveSelector selector) {
            this.archiveSelector = selector;
            return this;
        }

        public Builder config(ParsingConfig config) {
            this.config = config;
            return this;
        }

        public ParsingContext build() {
            return new ParsingContext(this);
        }
    }
}

