/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.util.jar.Manifest;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;

public class DirectoryArchive
implements ArchiveAdapter {
    public final File directory;

    public DirectoryArchive(File directory) {
        this.directory = directory;
    }

    @Override
    public URI getURI() {
        return this.directory.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        File manifest = new File(this.directory, "META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifest));
            try {
                Manifest manifest2 = new Manifest(is);
                return manifest2;
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return null;
    }

    @Override
    public void onEachEntry(ArchiveAdapter.EntryTask task) throws IOException {
        this.parse(this.directory, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File dir, ArchiveAdapter.EntryTask task) throws IOException {
        for (File f : dir.listFiles()) {
            ArchiveAdapter.Entry ae = new ArchiveAdapter.Entry(this.mangle(f), f.length(), f.isDirectory());
            if (!f.isDirectory()) {
                InputStream is = null;
                try {
                    is = Channels.newInputStream(new FileInputStream(f).getChannel());
                    task.on(ae, is);
                    continue;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            this.parse(f, task);
        }
    }

    private String mangle(File f) {
        String relativePath = f.getAbsolutePath().substring(this.directory.getAbsolutePath().length() + 1);
        return relativePath.replace(File.separatorChar, '/');
    }

    @Override
    public void close() throws IOException {
    }
}

