/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.util.InputStreamArchiveAdapter;

public class JarArchive
implements ArchiveAdapter {
    private final JarFile jar;
    private final URI uri;

    public JarArchive(URI uri) throws IOException {
        File f = new File(uri);
        this.uri = uri;
        this.jar = new JarFile(f);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEachEntry(ArchiveAdapter.EntryTask task) throws IOException {
        Enumeration<JarEntry> enumEntries = this.jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry ja = enumEntries.nextElement();
            if (ja.getName().endsWith(".jar")) {
                InputStreamArchiveAdapter subArchive = null;
                try {
                    URI subURI = null;
                    try {
                        subURI = new URI("jar:" + this.uri + "!/" + ja.getName());
                    }
                    catch (URISyntaxException e) {
                        try {
                            subURI = new URI(ja.getName());
                        }
                        catch (URISyntaxException e1) {
                            // empty catch block
                        }
                    }
                    subArchive = new InputStreamArchiveAdapter(subURI, this.jar.getInputStream(this.jar.getEntry(ja.getName())));
                    subArchive.onEachEntry(task);
                }
                finally {
                    if (subArchive != null) {
                        subArchive.close();
                    }
                }
            }
            InputStream is = null;
            try {
                is = this.jar.getInputStream(ja);
                task.on(new ArchiveAdapter.Entry(ja.getName(), ja.getSize(), ja.isDirectory()), is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jar.getManifest();
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }
}

