/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveSelector;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.impl.ModelClassVisitor;
import org.glassfish.hk2.classmodel.reflect.impl.TypesImpl;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.objectweb.asm.ClassVisitor;

public class ParsingContext {
    private final TypesImpl types = new TypesImpl();
    final ExecutorService executorService;
    final ArchiveSelector archiveSelector;
    final Logger logger;
    final ParsingConfig config;

    private ParsingContext(Builder builder) {
        Runtime runtime = Runtime.getRuntime();
        int nrOfProcessors = runtime.availableProcessors();
        this.executorService = builder.executorService == null ? Executors.newFixedThreadPool(nrOfProcessors) : builder.executorService;
        this.archiveSelector = builder.archiveSelector;
        this.logger = builder.logger;
        this.config = builder.config != null ? builder.config : new ParsingConfig(){
            final Set<String> emptyList = Collections.emptySet();

            @Override
            public Set<String> getInjectionTargetAnnotations() {
                return this.emptyList;
            }

            @Override
            public Set<String> getInjectionTargetInterfaces() {
                return this.emptyList;
            }

            @Override
            public Set<String> getInjectionPointsAnnotations() {
                return this.emptyList;
            }
        };
    }

    public ClassVisitor getClassVisitor() {
        return new ModelClassVisitor(this);
    }

    public Types getTypes() {
        return this.types;
    }

    public ParsingConfig getConfig() {
        return this.config;
    }

    public static class Builder {
        Logger logger = Logger.getLogger("org.glassfish.classmodel");
        ExecutorService executorService = null;
        ArchiveSelector archiveSelector = null;
        ParsingConfig config = null;

        public Logger logger() {
            return this.logger;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder executorService(ExecutorService service) {
            this.executorService = service;
            return this;
        }

        public Builder archiveSelector(ArchiveSelector selector) {
            this.archiveSelector = selector;
            return this;
        }

        public Builder config(ParsingConfig config) {
            this.config = config;
            return this;
        }

        public ParsingContext build() {
            return new ParsingContext(this);
        }
    }
}

