/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;

public class JarArchive
implements ArchiveAdapter {
    private final JarFile jar;
    private final List<ArchiveAdapter.Entry> entries = new ArrayList<ArchiveAdapter.Entry>();

    public JarArchive(JarFile jar) {
        this.jar = jar;
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry ja = enumEntries.nextElement();
            this.entries.add(new ArchiveAdapter.Entry(ja.getName(), ja.getSize(), ja.isDirectory()));
        }
    }

    @Override
    public InputStream getInputStream(String entry) throws IOException {
        JarEntry jarEntry = this.jar.getJarEntry(entry);
        if (jarEntry == null) {
            throw new IOException("Entry not found " + jarEntry);
        }
        return this.jar.getInputStream(jarEntry);
    }

    @Override
    public String getName() {
        return this.jar.getName();
    }

    @Override
    public Iterator<ArchiveAdapter.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jar.getManifest();
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }
}

