/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.util.DirectoryArchive;
import org.glassfish.hk2.classmodel.reflect.util.JarArchive;
import org.objectweb.asm.ClassReader;

public class Parser {
    private final ParsingContext context;
    private final List<Future<Result>> futures = Collections.synchronizedList(new ArrayList());

    public Parser(ParsingContext context) {
        this.context = context;
    }

    public Exception[] awaitTermination() throws InterruptedException {
        return this.awaitTermination(10, TimeUnit.SECONDS);
    }

    public synchronized Exception[] awaitTermination(int timeOut, TimeUnit unit) throws InterruptedException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.context.logger.isLoggable(Level.FINE)) {
            this.context.logger.log(Level.FINE, "awaiting termination of " + this.futures.size() + " tasks");
        }
        for (Future<Result> f : this.futures) {
            try {
                Result result = f.get(timeOut, unit);
                if (this.context.logger.isLoggable(Level.FINER)) {
                    this.context.logger.log(Level.FINER, "result " + result);
                    if (result != null && result.fault != null) {
                        this.context.logger.log(Level.FINER, "result fault" + result);
                    }
                }
                if (result == null || result.fault == null) continue;
                exceptions.add(result.fault);
            }
            catch (TimeoutException e) {
                exceptions.add(e);
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        return exceptions.toArray(new Exception[exceptions.size()]);
    }

    public void parse(File source, Runnable doneHook) throws IOException {
        ArchiveAdapter adapter = source.isFile() ? new JarArchive(new JarFile(source)) : new DirectoryArchive(source);
        this.parse(adapter, doneHook);
    }

    public synchronized void parse(final ArchiveAdapter source, final Runnable doneHook) throws IOException {
        if (this.context.logger.isLoggable(Level.FINE)) {
            this.context.logger.log(Level.FINE, "submitting file " + source.getName());
        }
        this.futures.add(this.context.executorService.submit(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                try {
                    if (((Parser)Parser.this).context.logger.isLoggable(Level.FINE)) {
                        ((Parser)Parser.this).context.logger.log(Level.FINE, "elected file " + source.getName());
                    }
                    Parser.this.doJob(source, doneHook);
                    return new Result(source.getName(), null);
                }
                catch (Exception e) {
                    ((Parser)Parser.this).context.logger.log(Level.SEVERE, "Exception while parsing file " + source, e);
                    return new Result(source.getName(), e);
                }
            }
        }));
    }

    private void doJob(ArchiveAdapter adapter, Runnable doneHook) throws Exception {
        if (this.context.archiveSelector == null || this.context.archiveSelector.selects(adapter)) {
            if (this.context.logger.isLoggable(Level.FINE)) {
                this.context.logger.log(Level.FINE, "Parsing file " + adapter.getName());
            }
            for (ArchiveAdapter.Entry entry : adapter) {
                if (!entry.name.endsWith(".class")) continue;
                if (this.context.logger.isLoggable(Level.FINER)) {
                    this.context.logger.log(Level.FINER, "Parsing class " + entry.name);
                }
                ClassReader cr = new ClassReader(adapter.getInputStream(entry.name));
                cr.accept(this.context.getClassVisitor(), 2);
            }
            if (this.context.logger.isLoggable(Level.FINE)) {
                this.context.logger.log(Level.FINE, "before running doneHook" + adapter.getName());
            }
            doneHook.run();
            if (this.context.logger.isLoggable(Level.FINE)) {
                this.context.logger.log(Level.FINE, "after running doneHook " + adapter.getName());
            }
        }
    }

    private class Result {
        final String name;
        final Exception fault;

        private Result(String name, Exception fault) {
            this.name = name;
            this.fault = fault;
        }

        public String toString() {
            return super.toString() + " Result for " + this.name;
        }
    }
}

