/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.caching.aop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.ConstructorInvocation;
import org.glassfish.examples.caching.aop.CacheKey;

public class CachingConstructorInterceptor
implements ConstructorInterceptor {
    private final HashMap<CacheKey, Object> cache = new HashMap();

    public Object construct(ConstructorInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        if (args.length != 1) {
            return invocation.proceed();
        }
        Object arg = args[0];
        if (arg == null) {
            return invocation.proceed();
        }
        Constructor c = invocation.getConstructor();
        CacheKey key = new CacheKey(c.getDeclaringClass().getName(), "<init>", arg);
        if (!this.cache.containsKey(key)) {
            Object retVal = invocation.proceed();
            this.cache.put(key, retVal);
            return retVal;
        }
        return this.cache.get(key);
    }
}

