/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.caching.aop;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.glassfish.examples.caching.aop.CacheKey;

public class CachingMethodInterceptor
implements MethodInterceptor {
    private final HashMap<CacheKey, Object> cache = new HashMap();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        if (args.length != 1) {
            return invocation.proceed();
        }
        Object arg = args[0];
        if (arg == null) {
            return invocation.proceed();
        }
        Method m = invocation.getMethod();
        CacheKey key = new CacheKey(m.getDeclaringClass().getName(), m.getName(), arg);
        if (!this.cache.containsKey(key)) {
            Object retVal = invocation.proceed();
            this.cache.put(key, retVal);
            return retVal;
        }
        return this.cache.get(key);
    }
}

