/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.caching.services;

import javax.inject.Inject;
import org.glassfish.examples.caching.hk2.Cache;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ExpensiveConstructor {
    private static int numTimesConstructed;
    private final int multiplier;

    @Inject
    @Cache
    public ExpensiveConstructor(int multiplier) {
        this.multiplier = multiplier * 2;
        ++numTimesConstructed;
    }

    public int getComputation() {
        return this.multiplier;
    }

    public static void clear() {
        numTimesConstructed = 0;
    }

    public static int getNumTimesConstructed() {
        return numTimesConstructed;
    }
}

