/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.jvnet.hk2.ExportedPackage;
import org.jvnet.hk2.ImportedPackage;
import org.jvnet.hk2.Named;
import org.jvnet.hk2.OSGiManifest;
import org.jvnet.hk2.Printer;
import org.jvnet.hk2.RequiredBundle;

public class PlainTextPrinter
implements Printer {
    private final PrintStream out;
    private final String WHITESPACE = "                                                      ";

    public PlainTextPrinter(PrintStream out) {
        this.out = out;
    }

    @Override
    public void print(OSGiManifest m) {
        this.out.println("Bundle-Name:         " + m.name);
        this.out.println("Bundle-Version:      " + m.version);
        this.out.println("Bundle-SymbolicName: " + m.symbolName);
        this.out.println("Export-Packages:");
        int w = Named.getLongestName(m.exportPackages);
        for (ExportedPackage exportedPackage : m.exportPackages) {
            this.out.print("  " + this.pad(exportedPackage.name, w));
            if (exportedPackage.include != null) {
                this.out.println();
                this.out.print("    " + this.pad("include: " + exportedPackage.include, w));
            }
            if (exportedPackage.version != null) {
                this.out.print(" " + exportedPackage.version);
            }
            this.out.println();
        }
        this.out.println("Import-Packages:");
        w = Named.getLongestName(m.importedPackages);
        for (ImportedPackage importedPackage : m.importedPackages) {
            this.out.print("  " + this.pad(importedPackage.name, w));
            for (Map.Entry<String, Set<String>> resolution : importedPackage.resolutions.entrySet()) {
                this.out.print("    resolution: " + resolution.getKey());
                this.out.println();
                for (String packageName : resolution.getValue()) {
                    this.out.print("      " + packageName);
                    this.out.println();
                }
            }
            if (importedPackage.version != null) {
                this.out.print(" " + importedPackage.version);
            }
            this.out.println();
        }
        this.out.println("Private-Packages:");
        this.printPackages(m.privatePackages);
        this.out.println("Require-Bundles:");
        w = Named.getLongestName(m.requiredBundles);
        for (RequiredBundle requiredBundle : m.requiredBundles) {
            this.out.print("  " + this.pad(requiredBundle.name, w));
            if (requiredBundle.version != null) {
                this.out.print(" " + requiredBundle.version);
            }
            this.out.println();
        }
        this.out.println();
    }

    private void printPackages(Set<String> packages) {
        for (String pkg : packages) {
            this.out.println("  " + pkg);
        }
    }

    private String pad(String str, int width) {
        while (((String)str).length() < width) {
            str = (String)str + "                                                      ".substring(0, Math.min("                                                      ".length(), width - ((String)str).length()));
        }
        return str;
    }
}

