/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.spi;

import java.util.HashMap;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.impl.NoOpBackingStoreFactory;
import org.glassfish.ha.store.spi.DuplicateFactoryRegistrationException;

public final class BackingStoreFactoryRegistry {
    private static final HashMap<String, BackingStoreFactory> factories = new HashMap();

    public static synchronized void register(String type, BackingStoreFactory factory) throws DuplicateFactoryRegistrationException {
        if (factories.get(type) != null) {
            throw new DuplicateFactoryRegistrationException("BackingStoreFactory for persistene-type " + type + " already exists");
        }
        factories.put(type, factory);
    }

    public static synchronized BackingStoreFactory getFactoryInstance(String type) throws BackingStoreException {
        BackingStoreFactory factory = factories.get(type);
        if (factory == null) {
            throw new BackingStoreException("Backing store for persistence-type " + type + " is not registered.");
        }
        return factory;
    }

    public static synchronized void unregister(String type) {
        factories.remove(type);
    }

    static {
        factories.put("noop", new NoOpBackingStoreFactory());
    }
}

