/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.glassfish.ha.store.criteria.Criteria;
import org.glassfish.ha.store.spi.BackingStoreException;
import org.glassfish.ha.store.spi.BackingStoreFactory;
import org.glassfish.ha.store.spi.BackingStoreRegistry;
import org.glassfish.ha.store.spi.ObjectInputOutputStreamFactory;
import org.glassfish.ha.store.spi.ObjectInputOutputStreamFactoryRegistry;
import org.glassfish.ha.store.spi.ObjectInputStreamWithLoader;
import org.glassfish.ha.store.spi.StoreEntryEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackingStore<K, V> {
    private String storeName;
    private Properties props;
    private Class<V> vClazz;

    protected Properties getProperties() {
        return this.props;
    }

    protected String getStoreName() {
        return this.storeName;
    }

    protected void initialize(String storeName, Class<K> keyClazz, Class<V> vClazz, Properties props) {
        this.storeName = storeName;
        this.vClazz = vClazz;
        this.props = props;
    }

    public static <S, T> BackingStore<S, T> createBackingStore(String storeType, String storeName, Class<S> keyClazz, Class<T> entryClazz, Properties env) throws BackingStoreException {
        BackingStore<S, T> store = null;
        BackingStoreFactory factory = null;
        try {
            factory = BackingStoreRegistry.getInstance().getFactoryInstance(storeType);
        }
        catch (BackingStoreException bse) {
            throw bse;
        }
        catch (Exception ex) {
            throw new BackingStoreException(ex.getMessage(), ex);
        }
        if (factory != null) {
            try {
                store = factory.createBackingStore(storeName, keyClazz, entryClazz, env);
            }
            catch (Throwable th) {
                throw new BackingStoreException("Exception during createBackingStore", th);
            }
        }
        return store;
    }

    public final V createStorable() {
        V v = null;
        try {
            v = this.vClazz.newInstance();
            String subClassName = this.vClazz.getName() + "__Sub__";
            Class<?> subClazz = Class.forName(subClassName);
            v = (V)subClazz.newInstance();
        }
        catch (Exception ex) {
            System.err.println(this.getClass().getName() + " Error while creating storable " + ex.getMessage());
        }
        return v;
    }

    public abstract V load(K var1, String var2) throws BackingStoreException;

    public abstract void save(K var1, V var2, boolean var3) throws BackingStoreException;

    public abstract void remove(K var1) throws BackingStoreException;

    public abstract void updateTimestamp(K var1, long var2) throws BackingStoreException;

    public abstract int removeExpired(long var1) throws BackingStoreException;

    public void removeByCriteria(Criteria<V> criteria, StoreEntryEvaluator<K, V> eval) throws BackingStoreException {
    }

    public abstract int size() throws BackingStoreException;

    public abstract void destroy() throws BackingStoreException;

    public Collection findByCriteria(Criteria<V> criteria, StoreEntryEvaluator<K, V> eval) {
        return Collections.EMPTY_LIST;
    }

    public void close() throws BackingStoreException {
    }

    public Collection synchronizeKeys(Criteria<V> criteria, StoreEntryEvaluator<K, V> eval, boolean eagerFetch) {
        return Collections.EMPTY_LIST;
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        ObjectInputOutputStreamFactory oosf = ObjectInputOutputStreamFactoryRegistry.getObjectInputOutputStreamFactory();
        return oosf.createObjectOutputStream(os);
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithLoader(is, this.vClazz.getClassLoader());
    }
}

