/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.simpleauth;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.samples.simpleauth.MultiLinePacket;

public class ServerAuthFilter
extends BaseFilter {
    private final Map<Connection, String> authenticatedConnections = new ConcurrentHashMap<Connection, String>();
    private final Random random = new Random();

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        MultiLinePacket packet = (MultiLinePacket)ctx.getMessage();
        String command = packet.getLines().get(0);
        if (command.startsWith("authentication-request")) {
            MultiLinePacket authResponse = this.authenticate(connection);
            ctx.write((Object)authResponse);
            return ctx.getStopAction();
        }
        String idLine = packet.getLines().get(1);
        if (this.checkAuth(connection, idLine)) {
            packet.getLines().remove(1);
            return ctx.getInvokeAction();
        }
        throw new IllegalStateException("Client is not authenticated!");
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        MultiLinePacket packet = (MultiLinePacket)ctx.getMessage();
        String command = packet.getLines().get(0);
        if (command.equals("authentication-response")) {
            return ctx.getInvokeAction();
        }
        String id = this.authenticatedConnections.get(connection);
        if (id != null) {
            packet.getLines().add(1, "auth-id: " + id);
            return ctx.getInvokeAction();
        }
        throw new IllegalStateException("Client is not authenticated");
    }

    private MultiLinePacket authenticate(Connection connection) {
        String id = String.valueOf(System.currentTimeMillis() ^ this.random.nextLong());
        this.authenticatedConnections.put(connection, id);
        MultiLinePacket response = MultiLinePacket.create();
        response.getLines().add("authentication-response");
        response.getLines().add("auth-id: " + id);
        return response;
    }

    private boolean checkAuth(Connection connection, String idLine) {
        String registeredId = this.authenticatedConnections.get(connection);
        if (registeredId == null) {
            return false;
        }
        if (idLine.startsWith("auth-id:")) {
            String id = this.getId(idLine);
            return registeredId.equals(id);
        }
        return false;
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.authenticatedConnections.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    private String getId(String idLine) {
        return idLine.split(":")[1].trim();
    }
}

