/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.filterchain;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.samples.filterchain.GIOPMessage;

public final class GIOPFilter
extends BaseFilter {
    private static final int HEADER_SIZE = 12;

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer sourceBuffer = (Buffer)ctx.getMessage();
        int sourceBufferLength = sourceBuffer.remaining();
        if (sourceBufferLength < 12) {
            return ctx.getStopAction((Object)sourceBuffer);
        }
        int bodyLength = sourceBuffer.getInt(8);
        int completeMessageLength = 12 + bodyLength;
        if (sourceBufferLength < completeMessageLength) {
            return ctx.getStopAction((Object)sourceBuffer);
        }
        Buffer remainder = sourceBufferLength > completeMessageLength ? sourceBuffer.split(completeMessageLength) : null;
        GIOPMessage giopMessage = new GIOPMessage();
        giopMessage.setGIOPHeader(sourceBuffer.get(), sourceBuffer.get(), sourceBuffer.get(), sourceBuffer.get());
        giopMessage.setMajor(sourceBuffer.get());
        giopMessage.setMinor(sourceBuffer.get());
        giopMessage.setFlags(sourceBuffer.get());
        giopMessage.setValue(sourceBuffer.get());
        giopMessage.setBodyLength(sourceBuffer.getInt());
        byte[] body = new byte[bodyLength];
        sourceBuffer.get(body);
        giopMessage.setBody(body);
        ctx.setMessage((Object)giopMessage);
        sourceBuffer.tryDispose();
        return ctx.getInvokeAction((Object)remainder);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        GIOPMessage giopMessage = (GIOPMessage)ctx.getMessage();
        int size = 12 + giopMessage.getBodyLength();
        MemoryManager memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        Buffer output = memoryManager.allocate(size);
        output.allowBufferDispose(true);
        output.put(giopMessage.getGIOPHeader());
        output.put(giopMessage.getMajor());
        output.put(giopMessage.getMinor());
        output.put(giopMessage.getFlags());
        output.put(giopMessage.getValue());
        output.putInt(giopMessage.getBodyLength());
        output.put(giopMessage.getBody());
        ctx.setMessage((Object)output.flip());
        return ctx.getInvokeAction();
    }
}

