/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.tunnel;

import java.io.IOException;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.tunnel.TunnelFilter;
import org.slf4j.Logger;

public class TunnelServer {
    private static final Logger LOGGER = Grizzly.logger(TunnelServer.class);
    public static final String HOST = "localhost";
    public static final int PORT = 7777;
    public static final String REDIRECT_HOST = "localhost";
    public static final int REDIRECT_PORT = 5001;

    public static void main(String[] args) throws IOException {
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new TunnelFilter((SocketConnectorHandler)TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).build(), "localhost", 5001));
        transport.setProcessor((Processor)filterChainBuilder.build());
        transport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(262144);
        try {
            transport.bind("localhost", 7777);
            transport.start();
            LOGGER.info("Press any key to stop the server...");
            System.in.read();
        }
        finally {
            LOGGER.info("Stopping transport...");
            transport.shutdownNow();
            LOGGER.info("Stopped transport...");
        }
    }
}

