/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.simpleauth;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferOutputStream;
import org.glassfish.grizzly.utils.StringFilter;
import org.slf4j.Logger;

public class MultiStringFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(StringFilter.class);
    protected final Charset charset;
    protected final Attribute<DecodeResult> decodeStateAttr;
    protected final byte[] stringTerminateBytes;

    public MultiStringFilter() {
        this(null, null);
    }

    public MultiStringFilter(Charset charset) {
        this(charset, null);
    }

    public MultiStringFilter(Charset charset, String stringTerminate) {
        this.charset = charset != null ? charset : Charset.defaultCharset();
        this.stringTerminateBytes = stringTerminate != null ? stringTerminate.getBytes(this.charset) : null;
        this.decodeStateAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(MultiStringFilter.class.getName() + ".string-length");
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        DecodeResult newState;
        Connection connection = ctx.getConnection();
        DecodeResult prevState = (DecodeResult)this.decodeStateAttr.get((AttributeStorage)connection);
        Buffer input = (Buffer)ctx.getMessage();
        if (!input.hasRemaining()) {
            return ctx.getStopAction();
        }
        List<String> stringList = null;
        while ((newState = this.decode(input, prevState)).isDone()) {
            if (stringList == null) {
                stringList = this.createInList();
            }
            stringList.add(newState.getResult());
            newState.reset();
            if (input.hasRemaining()) continue;
        }
        if (newState.isClear() && prevState != null) {
            this.decodeStateAttr.remove((AttributeStorage)connection);
        } else if (!newState.isClear() && prevState == null) {
            this.decodeStateAttr.set((AttributeStorage)connection, (Object)newState);
        }
        if (stringList != null) {
            Buffer remainder = input.split(input.position());
            input.tryDispose();
            ctx.setMessage(stringList);
            return ctx.getInvokeAction((Object)remainder, Buffers.getBufferAppender((boolean)true));
        }
        return ctx.getStopAction((Object)input);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Object input = ctx.getMessage();
        if (!(input instanceof List)) {
            return ctx.getInvokeAction();
        }
        List inputStringList = (List)ctx.getMessage();
        Buffer output = this.encode(ctx.getMemoryManager(), inputStringList);
        ctx.setMessage((Object)output);
        return ctx.getInvokeAction();
    }

    public DecodeResult decode(Buffer inputBuffer, DecodeResult decodeResult) {
        return this.stringTerminateBytes == null ? this.parseWithLengthPrefix(inputBuffer, decodeResult) : this.parseWithTerminatingSeq(inputBuffer, decodeResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer encode(MemoryManager mm, List<String> inputStringList) throws IOException {
        String charsetName = this.charset.name();
        BufferOutputStream baos = new BufferOutputStream(mm, mm.allocate(1024));
        try (DataOutputStream dos = new DataOutputStream((OutputStream)baos);){
            for (String inputString : inputStringList) {
                byte[] byteRepresentation;
                try {
                    byteRepresentation = inputString.getBytes(charsetName);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Charset " + this.charset.name() + " is not supported", e);
                }
                if (this.stringTerminateBytes == null) {
                    dos.writeInt(byteRepresentation.length);
                }
                dos.write(byteRepresentation);
                if (this.stringTerminateBytes == null) continue;
                dos.write(this.stringTerminateBytes);
            }
        }
        Buffer output = baos.getBuffer();
        output.trim();
        output.allowBufferDispose(true);
        return output;
    }

    protected DecodeResult parseWithLengthPrefix(Buffer input, DecodeResult decodeResult) {
        int stringSize;
        if (decodeResult == null) {
            decodeResult = new DecodeResult();
        } else if (decodeResult.isDone()) {
            return decodeResult;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("StringFilter decode stringSize={} buffer={} content={}", new Object[]{decodeResult.state, input, input.toStringContent()});
        }
        if ((stringSize = decodeResult.state) == -1) {
            if (input.remaining() < 4) {
                return decodeResult;
            }
            stringSize = input.getInt();
            decodeResult.state = stringSize;
        }
        if (input.remaining() < stringSize) {
            return decodeResult;
        }
        String stringMessage = input.toStringContent(this.charset, input.position(), input.position() + stringSize);
        input.position(input.position() + stringSize);
        decodeResult.done(stringMessage);
        return decodeResult;
    }

    protected DecodeResult parseWithTerminatingSeq(Buffer input, DecodeResult decodeResult) {
        if (decodeResult == null) {
            decodeResult = new DecodeResult();
        } else if (decodeResult.isDone()) {
            return decodeResult;
        }
        int terminationBytesLength = this.stringTerminateBytes.length;
        int checkIndex = 0;
        int termIndex = -1;
        int offset = 0;
        if (decodeResult.state != -1) {
            offset = decodeResult.state;
        }
        for (int i = input.position() + offset; i < input.limit(); ++i) {
            if (input.get(i) != this.stringTerminateBytes[checkIndex] || ++checkIndex < terminationBytesLength) continue;
            termIndex = i - terminationBytesLength + 1;
            break;
        }
        if (termIndex >= 0) {
            String stringMessage = input.toStringContent(this.charset, input.position(), termIndex);
            decodeResult.done(stringMessage);
            input.position(termIndex + terminationBytesLength);
        } else {
            offset = input.remaining() - terminationBytesLength;
            if (offset < 0) {
                offset = 0;
            }
            decodeResult.state = offset;
        }
        return decodeResult;
    }

    protected List<String> createInList() {
        return new ArrayList<String>(4);
    }

    public static class DecodeResult {
        private String result;
        private int state = -1;

        public boolean isDone() {
            return this.result != null;
        }

        public String getResult() {
            return this.result;
        }

        private void done(String result) {
            this.result = result;
        }

        void reset() {
            this.state = -1;
            this.result = null;
        }

        private boolean isClear() {
            return this.state == -1;
        }
    }
}

