/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.udpmulticast;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.utils.Futures;

public abstract class ChatCommand {
    public static ChatCommand parse(String command) throws Exception {
        int id;
        if (command == null) {
            return null;
        }
        String[] splitString = command.trim().split(" ");
        if (splitString.length == 0) {
            return null;
        }
        try {
            id = Integer.valueOf(splitString[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("Bad command: can't parse command id");
            return null;
        }
        switch (id) {
            case 1: {
                return new SendMsgCommand(splitString);
            }
            case 2: {
                return new JoinGroupCommand(splitString);
            }
            case 3: {
                return new LeaveGroupCommand(splitString);
            }
            case 4: {
                return new BlockSourceCommand(splitString);
            }
            case 5: {
                return new UnblockSourceCommand(splitString);
            }
            case 6: {
                return new ListNetworkInterfacesCommand(splitString);
            }
            case 7: {
                return new ExitCommand(splitString);
            }
        }
        return null;
    }

    public boolean isExit() {
        return false;
    }

    public abstract void run(UDPNIOConnection var1) throws Exception;

    private static class ExitCommand
    extends ChatCommand {
        public ExitCommand(String[] params) throws Exception {
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
        }

        @Override
        public boolean isExit() {
            return true;
        }
    }

    private static class ListNetworkInterfacesCommand
    extends ChatCommand {
        public ListNetworkInterfacesCommand(String[] params) throws Exception {
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
            Enumeration<NetworkInterface> niEnumeration = NetworkInterface.getNetworkInterfaces();
            while (niEnumeration.hasMoreElements()) {
                NetworkInterface ni = niEnumeration.nextElement();
                System.out.println(ni.getName() + " support-multicast=" + ni.supportsMulticast());
            }
        }
    }

    private static class UnblockSourceCommand
    extends ChatCommand {
        private final InetAddress groupAddr;
        private final NetworkInterface ni;
        private final InetAddress source;

        public UnblockSourceCommand(String[] params) throws Exception {
            if (params.length != 4) {
                throw new IllegalArgumentException("Unblock source command expects 3 parameters: group_addr network_interface source");
            }
            this.groupAddr = InetAddress.getByName(params[1]);
            try {
                this.ni = NetworkInterface.getByName(params[2]) != null ? NetworkInterface.getByName(params[2]) : NetworkInterface.getByInetAddress(InetAddress.getByName(params[2]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Passed network interface can't be resolved");
            }
            this.source = InetAddress.getByName(params[3]);
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
            connection.unblock(this.groupAddr, this.ni, this.source);
        }
    }

    private static class BlockSourceCommand
    extends ChatCommand {
        private final InetAddress groupAddr;
        private final NetworkInterface ni;
        private final InetAddress source;

        public BlockSourceCommand(String[] params) throws Exception {
            if (params.length != 4) {
                throw new IllegalArgumentException("Block source command expects 3 parameters: group_addr network_interface source");
            }
            this.groupAddr = InetAddress.getByName(params[1]);
            try {
                this.ni = NetworkInterface.getByName(params[2]) != null ? NetworkInterface.getByName(params[2]) : NetworkInterface.getByInetAddress(InetAddress.getByName(params[2]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Passed network interface can't be resolved");
            }
            this.source = InetAddress.getByName(params[3]);
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
            connection.block(this.groupAddr, this.ni, this.source);
        }
    }

    private static class LeaveGroupCommand
    extends ChatCommand {
        private final InetAddress groupAddr;
        private final NetworkInterface ni;
        private final InetAddress source;

        public LeaveGroupCommand(String[] params) throws Exception {
            if (params.length != 3 && params.length != 4) {
                throw new IllegalArgumentException("Leave group command expects 3 parameters (1 optional): group_addr network_interface [source]");
            }
            this.groupAddr = InetAddress.getByName(params[1]);
            try {
                this.ni = NetworkInterface.getByName(params[2]) != null ? NetworkInterface.getByName(params[2]) : NetworkInterface.getByInetAddress(InetAddress.getByName(params[2]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Passed network interface can't be resolved");
            }
            this.source = params.length == 4 ? InetAddress.getByName(params[3]) : null;
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
            connection.drop(this.groupAddr, this.ni, this.source);
            try {
                InetSocketAddress peerAddr = new InetSocketAddress(this.groupAddr, ((InetSocketAddress)connection.getLocalAddress()).getPort());
                FutureImpl writeFuture = Futures.createSafeFuture();
                connection.write((SocketAddress)peerAddr, (Object)("left the group " + this.groupAddr), Futures.toCompletionHandler((FutureImpl)writeFuture));
                writeFuture.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class JoinGroupCommand
    extends ChatCommand {
        private final InetAddress groupAddr;
        private final NetworkInterface ni;
        private final InetAddress source;

        public JoinGroupCommand(String[] params) throws Exception {
            if (params.length != 3 && params.length != 4) {
                throw new IllegalArgumentException("Join group command expects 3 parameters (1 optional): group_addr network_interface [source]");
            }
            this.groupAddr = InetAddress.getByName(params[1]);
            try {
                this.ni = NetworkInterface.getByName(params[2]) != null ? NetworkInterface.getByName(params[2]) : NetworkInterface.getByInetAddress(InetAddress.getByName(params[2]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Passed network interface can't be resolved");
            }
            this.source = params.length == 4 ? InetAddress.getByName(params[3]) : null;
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
            connection.join(this.groupAddr, this.ni, this.source);
            InetSocketAddress peerAddr = new InetSocketAddress(this.groupAddr, ((InetSocketAddress)connection.getLocalAddress()).getPort());
            FutureImpl writeFuture = Futures.createSafeFuture();
            connection.write((SocketAddress)peerAddr, (Object)("joined the group " + this.groupAddr), Futures.toCompletionHandler((FutureImpl)writeFuture));
            writeFuture.get(10L, TimeUnit.SECONDS);
        }
    }

    private static class SendMsgCommand
    extends ChatCommand {
        private final InetAddress groupAddr;
        private final String msg;

        public SendMsgCommand(String[] params) throws Exception {
            if (params.length < 3) {
                throw new IllegalArgumentException("Send message command expects 2 parameters: group_addr message");
            }
            this.groupAddr = InetAddress.getByName(params[1]);
            StringBuilder messageBuilder = new StringBuilder();
            for (int i = 2; i < params.length; ++i) {
                if (messageBuilder.length() > 0) {
                    messageBuilder.append(' ');
                }
                messageBuilder.append(params[i].trim());
            }
            this.msg = messageBuilder.toString();
        }

        @Override
        public void run(UDPNIOConnection connection) throws Exception {
            InetSocketAddress peerAddr = new InetSocketAddress(this.groupAddr, ((InetSocketAddress)connection.getLocalAddress()).getPort());
            FutureImpl writeFuture = Futures.createSafeFuture();
            connection.write((SocketAddress)peerAddr, (Object)this.msg, Futures.toCompletionHandler((FutureImpl)writeFuture));
            writeFuture.get(10L, TimeUnit.SECONDS);
        }
    }
}

