/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.tunnel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class TunnelFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(TunnelFilter.class);
    private final Attribute<Connection> peerConnectionAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("TunnelFilter.peerConnection");
    private final SocketConnectorHandler transport;
    private final SocketAddress redirectAddress;

    public TunnelFilter(SocketConnectorHandler transport, String host, int port) {
        this(transport, new InetSocketAddress(host, port));
    }

    public TunnelFilter(SocketConnectorHandler transport, SocketAddress redirectAddress) {
        this.transport = transport;
        this.redirectAddress = redirectAddress;
    }

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "Connection: {0} handleRead: {1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
        Connection connection = ctx.getConnection();
        Connection peerConnection = (Connection)this.peerConnectionAttribute.get((AttributeStorage)connection);
        if (!connection.isOpen()) {
            return ctx.getStopAction();
        }
        NextAction suspendNextAction = ctx.getSuspendAction();
        if (peerConnection == null) {
            this.transport.connect((Object)this.redirectAddress, (CompletionHandler)new ConnectCompletionHandler(ctx));
            return suspendNextAction;
        }
        Object message = ctx.getMessage();
        TunnelFilter.redirectToPeer(ctx, peerConnection, message);
        AsyncQueueWriter writer = (AsyncQueueWriter)connection.getTransport().getWriter(false);
        if (writer.canWrite(peerConnection)) {
            return ctx.getStopAction();
        }
        ctx.suspend();
        writer.notifyWritePossible(peerConnection, new WriteHandler(){

            public void onWritePossible() throws Exception {
                this.finish();
            }

            public void onError(Throwable t) {
                this.finish();
            }

            private void finish() {
                ctx.resumeNext();
            }
        });
        return suspendNextAction;
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Connection peerConnection = (Connection)this.peerConnectionAttribute.get((AttributeStorage)connection);
        if (peerConnection != null && peerConnection.isOpen()) {
            peerConnection.closeSilently();
        }
        return ctx.getInvokeAction();
    }

    private static void redirectToPeer(FilterChainContext context, Connection peerConnection, Object message) throws IOException {
        Connection srcConnection = context.getConnection();
        logger.log(Level.FINE, "Redirecting from {0} to {1} message: {2}", new Object[]{srcConnection.getPeerAddress(), peerConnection.getPeerAddress(), message});
        peerConnection.write(message);
    }

    private class ConnectCompletionHandler
    implements CompletionHandler<Connection> {
        private final FilterChainContext context;

        private ConnectCompletionHandler(FilterChainContext context) {
            this.context = context;
        }

        public void cancelled() {
            this.context.getConnection().closeSilently();
            this.resumeContext();
        }

        public void failed(Throwable throwable) {
            this.context.getConnection().closeSilently();
            this.resumeContext();
        }

        public void completed(Connection peerConnection) {
            Connection connection = this.context.getConnection();
            TunnelFilter.this.peerConnectionAttribute.set((AttributeStorage)connection, (Object)peerConnection);
            TunnelFilter.this.peerConnectionAttribute.set((AttributeStorage)peerConnection, (Object)connection);
            this.resumeContext();
        }

        public void updated(Connection peerConnection) {
        }

        private void resumeContext() {
            this.context.resume();
        }
    }
}

