/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.lifecycle;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.DataStructures;

public class LifeCycleFilter
extends BaseFilter {
    private final Attribute<Integer> connectionIdAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-id");
    private final AtomicInteger totalConnectionNumber = new AtomicInteger();
    private final Map<Connection, Integer> activeConnectionsMap = DataStructures.getConcurrentMap();

    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        this.newConnection(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        this.newConnection(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.activeConnectionsMap.remove(ctx.getConnection());
        return super.handleClose(ctx);
    }

    private void newConnection(Connection connection) {
        Integer id = this.totalConnectionNumber.incrementAndGet();
        this.connectionIdAttribute.set((AttributeStorage)connection, (Object)id);
        this.activeConnectionsMap.put(connection, id);
    }

    public int getTotalConnections() {
        return this.totalConnectionNumber.get();
    }

    public Set<Connection> getActiveConnections() {
        return this.activeConnectionsMap.keySet();
    }
}

