/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.strategy;

import java.io.IOException;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.echo.EchoFilter;
import org.glassfish.grizzly.strategies.LeaderFollowerNIOStrategy;

public class CustomStrategy {
    public static final String HOST = "localhost";
    public static final int PORT = 7777;

    public static void main(String[] args) throws IOException {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        transport.setIOStrategy((IOStrategy)LeaderFollowerNIOStrategy.getInstance());
        try {
            transport.bind(HOST, 7777);
            transport.start();
            System.out.println("Press any key to stop the server...");
            System.in.read();
        }
        finally {
            System.out.println("Stopping transport...");
            transport.shutdownNow();
            System.out.println("Stopped transport...");
        }
    }
}

