/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.echo;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class EchoFilterAsync
extends BaseFilter {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        final Object message = ctx.getMessage();
        final Object peerAddress = ctx.getAddress();
        NextAction suspendActipn = ctx.getSuspendAction();
        ctx.suspend();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ctx.write(peerAddress, message, null);
                ctx.resumeNext();
            }
        }, 5L, TimeUnit.SECONDS);
        return suspendActipn;
    }
}

